/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg.sig;

import org.vafer.jdeb.shaded.bc.bcpg.FingerprintUtil;
import org.vafer.jdeb.shaded.bc.bcpg.KeyIdentifier;
import org.vafer.jdeb.shaded.bc.bcpg.SignatureSubpacket;
import org.vafer.jdeb.shaded.bc.util.Arrays;

public class IssuerFingerprint
extends SignatureSubpacket {
    public IssuerFingerprint(boolean bl, boolean bl2, byte[] byArray) {
        super(33, bl, bl2, byArray);
    }

    public IssuerFingerprint(boolean bl, int n, byte[] byArray) {
        super(33, bl, false, Arrays.prepend(byArray, (byte)n));
    }

    public int getKeyVersion() {
        return this.data[0] & 0xFF;
    }

    public byte[] getFingerprint() {
        return Arrays.copyOfRange(this.data, 1, this.data.length);
    }

    public long getKeyID() {
        if (this.getKeyVersion() == 4) {
            return FingerprintUtil.keyIdFromV4Fingerprint(this.getFingerprint());
        }
        if (this.getKeyVersion() == 5) {
            return FingerprintUtil.keyIdFromLibrePgpFingerprint(this.getFingerprint());
        }
        if (this.getKeyVersion() == 6) {
            return FingerprintUtil.keyIdFromV6Fingerprint(this.getFingerprint());
        }
        return 0L;
    }

    public KeyIdentifier getKeyIdentifier() {
        return new KeyIdentifier(this.getFingerprint());
    }
}

