/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg.sig;

import java.util.ArrayList;
import java.util.List;
import org.vafer.jdeb.shaded.bc.bcpg.sig.PreferredAlgorithms;

public class PreferredAEADCiphersuites
extends PreferredAlgorithms {
    private final Combination[] algorithms;
    private static final Combination AES_128_OCB = new Combination(7, 2);

    public static PreferredAEADCiphersuites DEFAULT() {
        return new PreferredAEADCiphersuites(false, new Combination[]{AES_128_OCB});
    }

    public PreferredAEADCiphersuites(boolean bl, boolean bl2, byte[] byArray) {
        super(39, bl, bl2, PreferredAEADCiphersuites.requireEven(byArray));
        this.algorithms = PreferredAEADCiphersuites.parseCombinations(byArray);
    }

    public PreferredAEADCiphersuites(boolean bl, Combination[] combinationArray) {
        this(bl, false, PreferredAEADCiphersuites.encodeCombinations(combinationArray));
    }

    private static Combination[] parseCombinations(byte[] byArray) {
        Combination[] combinationArray = new Combination[byArray.length / 2];
        for (int i = 0; i < combinationArray.length; ++i) {
            combinationArray[i] = new Combination(byArray[i * 2], byArray[i * 2 + 1]);
        }
        return combinationArray;
    }

    private static byte[] encodeCombinations(Combination[] combinationArray) {
        byte[] byArray = new byte[combinationArray.length * 2];
        for (int i = 0; i < combinationArray.length; ++i) {
            Combination combination = combinationArray[i];
            byArray[i * 2] = (byte)(combination.getSymmetricAlgorithm() & 0xFF);
            byArray[i * 2 + 1] = (byte)(combination.getAeadAlgorithm() & 0xFF);
        }
        return byArray;
    }

    public boolean isSupported(Combination combination) {
        return PreferredAEADCiphersuites.contains(combination, this.getAlgorithms());
    }

    private static boolean contains(Combination combination, Combination[] combinationArray) {
        for (int i = 0; i != combinationArray.length; ++i) {
            Combination combination2 = combinationArray[i];
            if (!combination2.equals(combination)) continue;
            return true;
        }
        return false;
    }

    public Combination[] getRawAlgorithms() {
        Combination[] combinationArray = new Combination[this.algorithms.length];
        System.arraycopy(this.algorithms, 0, combinationArray, 0, this.algorithms.length);
        return combinationArray;
    }

    public Combination[] getAlgorithms() {
        if (!PreferredAEADCiphersuites.contains(AES_128_OCB, this.algorithms)) {
            Combination[] combinationArray = new Combination[this.algorithms.length + 1];
            System.arraycopy(this.algorithms, 0, combinationArray, 0, this.algorithms.length);
            combinationArray[this.algorithms.length] = AES_128_OCB;
            return combinationArray;
        }
        return this.getRawAlgorithms();
    }

    private static byte[] requireEven(byte[] byArray) {
        if (byArray.length % 2 != 0) {
            throw new IllegalArgumentException("Even number of bytes expected.");
        }
        return byArray;
    }

    public static Builder builder(boolean bl) {
        return new Builder(bl);
    }

    public static final class Builder {
        private final List<Combination> combinations = new ArrayList<Combination>();
        private final boolean isCritical;

        private Builder(boolean bl) {
            this.isCritical = bl;
        }

        public Builder addCombination(int n, int n2) {
            this.combinations.add(new Combination(n, n2));
            return this;
        }

        public PreferredAEADCiphersuites build() {
            return new PreferredAEADCiphersuites(this.isCritical, this.combinations.toArray(new Combination[0]));
        }
    }

    public static class Combination {
        private final int symmetricAlgorithm;
        private final int aeadAlgorithm;

        public Combination(int n, int n2) {
            this.symmetricAlgorithm = n;
            this.aeadAlgorithm = n2;
        }

        public int getSymmetricAlgorithm() {
            return this.symmetricAlgorithm;
        }

        public int getAeadAlgorithm() {
            return this.aeadAlgorithm;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof Combination)) {
                return false;
            }
            Combination combination = (Combination)object;
            return this.getSymmetricAlgorithm() == combination.getSymmetricAlgorithm() && this.getAeadAlgorithm() == combination.getAeadAlgorithm();
        }

        public int hashCode() {
            return 13 * this.getSymmetricAlgorithm() + 17 * this.getAeadAlgorithm();
        }
    }
}

