/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp;

import java.io.InputStream;
import org.vafer.jdeb.shaded.bc.bcpg.AEADEncDataPacket;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGInputStream;
import org.vafer.jdeb.shaded.bc.bcpg.InputStreamPacket;
import org.vafer.jdeb.shaded.bc.bcpg.SymmetricEncIntegrityPacket;
import org.vafer.jdeb.shaded.bc.bcpg.UnsupportedPacketVersionException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPDataValidationException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPEncryptedData;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSessionKey;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPDataDecryptor;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPDataDecryptorFactory;

public class PGPSymmetricKeyEncryptedData
extends PGPEncryptedData {
    protected PGPSymmetricKeyEncryptedData(InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
    }

    protected InputStream createDecryptionStream(PGPDataDecryptorFactory pGPDataDecryptorFactory, PGPSessionKey pGPSessionKey) throws PGPException {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aEADEncDataPacket = (AEADEncDataPacket)this.encData;
            if (aEADEncDataPacket.getAlgorithm() != pGPSessionKey.getAlgorithm()) {
                throw new PGPException("session key and AEAD algorithm mismatch");
            }
            PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(aEADEncDataPacket, pGPSessionKey);
            BCPGInputStream bCPGInputStream = this.encData.getInputStream();
            return new BCPGInputStream(pGPDataDecryptor.getInputStream(bCPGInputStream));
        }
        if (this.encData instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)this.encData;
            if (symmetricEncIntegrityPacket.getVersion() == 1) {
                PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(true, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
                return this.getDataStream(true, pGPDataDecryptor);
            }
            if (symmetricEncIntegrityPacket.getVersion() == 2) {
                PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
                return new BCPGInputStream(pGPDataDecryptor.getInputStream(this.encData.getInputStream()));
            }
            throw new UnsupportedPacketVersionException("Unsupported SEIPD packet version: " + symmetricEncIntegrityPacket.getVersion());
        }
        PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(false, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
        return this.getDataStream(false, pGPDataDecryptor);
    }

    private InputStream getDataStream(boolean bl, PGPDataDecryptor pGPDataDecryptor) throws PGPException {
        try {
            BCPGInputStream bCPGInputStream = this.encData.getInputStream();
            bCPGInputStream.mark(pGPDataDecryptor.getBlockSize() + 2);
            if (this.processSymmetricEncIntegrityPacketDataStream(bl, pGPDataDecryptor, bCPGInputStream)) {
                bCPGInputStream.reset();
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }
}

