/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp.operator.bc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.vafer.jdeb.shaded.bc.bcpg.AEADEncDataPacket;
import org.vafer.jdeb.shaded.bc.bcpg.AEADUtils;
import org.vafer.jdeb.shaded.bc.bcpg.SymmetricEncIntegrityPacket;
import org.vafer.jdeb.shaded.bc.bcpg.SymmetricKeyUtils;
import org.vafer.jdeb.shaded.bc.crypto.BlockCipher;
import org.vafer.jdeb.shaded.bc.crypto.InvalidCipherTextException;
import org.vafer.jdeb.shaded.bc.crypto.digests.SHA256Digest;
import org.vafer.jdeb.shaded.bc.crypto.engines.AESEngine;
import org.vafer.jdeb.shaded.bc.crypto.engines.CamelliaEngine;
import org.vafer.jdeb.shaded.bc.crypto.generators.HKDFBytesGenerator;
import org.vafer.jdeb.shaded.bc.crypto.modes.AEADBlockCipher;
import org.vafer.jdeb.shaded.bc.crypto.modes.EAXBlockCipher;
import org.vafer.jdeb.shaded.bc.crypto.modes.GCMBlockCipher;
import org.vafer.jdeb.shaded.bc.crypto.modes.OCBBlockCipher;
import org.vafer.jdeb.shaded.bc.crypto.params.AEADParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.HKDFParameters;
import org.vafer.jdeb.shaded.bc.crypto.params.KeyParameter;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSessionKey;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPDataDecryptor;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPDigestCalculator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.vafer.jdeb.shaded.bc.util.Arrays;
import org.vafer.jdeb.shaded.bc.util.Exceptions;
import org.vafer.jdeb.shaded.bc.util.Pack;
import org.vafer.jdeb.shaded.bc.util.io.Streams;

public class BcAEADUtil {
    static final String RecoverAEADEncryptedSessionDataErrorMessage = "Exception recovering session info";
    private static final String ProcessAeadKeyDataErrorMessage = "Exception recovering AEAD protected private key material";
    static final String GetEskAndTagErrorMessage = "cannot encrypt session info";

    protected static byte[] getNonce(byte[] byArray, long l) {
        byte[] byArray2 = Arrays.clone(byArray);
        BcAEADUtil.xorChunkId(byArray2, l);
        return byArray2;
    }

    protected static void xorChunkId(byte[] byArray, long l) {
        int n = byArray.length - 8;
        int n2 = n++;
        byArray[n2] = (byte)(byArray[n2] ^ (byte)(l >> 56));
        int n3 = n++;
        byArray[n3] = (byte)(byArray[n3] ^ (byte)(l >> 48));
        int n4 = n++;
        byArray[n4] = (byte)(byArray[n4] ^ (byte)(l >> 40));
        int n5 = n++;
        byArray[n5] = (byte)(byArray[n5] ^ (byte)(l >> 32));
        int n6 = n++;
        byArray[n6] = (byte)(byArray[n6] ^ (byte)(l >> 24));
        int n7 = n++;
        byArray[n7] = (byte)(byArray[n7] ^ (byte)(l >> 16));
        int n8 = n++;
        byArray[n8] = (byte)(byArray[n8] ^ (byte)(l >> 8));
        int n9 = n;
        byArray[n9] = (byte)(byArray[n9] ^ (byte)l);
    }

    protected static long getChunkLength(int n) {
        return 1L << n + 6;
    }

    static byte[][] deriveMessageKeyAndIv(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n3 = SymmetricKeyUtils.getKeyLengthInOctets(n2);
        int n4 = AEADUtils.getIVLength(n);
        byte[] byArray4 = BcAEADUtil.generateHKDFBytes(byArray, byArray2, byArray3, n3 + n4 - 8);
        return new byte[][]{Arrays.copyOfRange(byArray4, 0, n3), Arrays.copyOfRange(byArray4, n3, n3 + n4)};
    }

    static byte[] generateHKDFBytes(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        HKDFParameters hKDFParameters = new HKDFParameters(byArray, byArray2, byArray3);
        HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator(new SHA256Digest());
        hKDFBytesGenerator.init(hKDFParameters);
        byte[] byArray4 = new byte[n];
        hKDFBytesGenerator.generateBytes(byArray4, 0, byArray4.length);
        return byArray4;
    }

    public static AEADBlockCipher createAEADCipher(int n, int n2) throws PGPException {
        if (n == 7 || n == 8 || n == 9) {
            return BcAEADUtil.createAEADCipher(n2, new Engine(){

                @Override
                public BlockCipher newInstance() {
                    return AESEngine.newInstance();
                }
            });
        }
        if (n == 11 || n == 12 || n == 13) {
            return BcAEADUtil.createAEADCipher(n2, new Engine(){

                @Override
                public BlockCipher newInstance() {
                    return new CamelliaEngine();
                }
            });
        }
        throw new PGPException("AEAD only supported for AES and Camellia based algorithms");
    }

    private static AEADBlockCipher createAEADCipher(int n, Engine engine) throws PGPException {
        switch (n) {
            case 1: {
                return new EAXBlockCipher(engine.newInstance());
            }
            case 2: {
                return new OCBBlockCipher(engine.newInstance(), engine.newInstance());
            }
            case 3: {
                return GCMBlockCipher.newInstance(engine.newInstance());
            }
        }
        throw new PGPException("unrecognised AEAD algorithm: " + n);
    }

    static PGPDataDecryptor createOpenPgpV5DataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        final byte by = aEADEncDataPacket.getAEADAlgorithm();
        final byte[] byArray = aEADEncDataPacket.getIV();
        final int n = aEADEncDataPacket.getChunkSize();
        final int n2 = pGPSessionKey.getAlgorithm();
        byte[] byArray2 = pGPSessionKey.getKey();
        final byte[] byArray3 = aEADEncDataPacket.getAAData();
        final KeyParameter keyParameter = new KeyParameter(byArray2);
        final AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(n2, by);
        return new PGPDataDecryptor(){

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                try {
                    return new PGPAeadInputStream(true, inputStream, aEADBlockCipher, keyParameter, byArray, n2, by, n, byArray3);
                }
                catch (IOException iOException) {
                    throw Exceptions.illegalStateException("unable to open stream: " + iOException.getMessage(), iOException);
                }
            }

            @Override
            public int getBlockSize() {
                return aEADBlockCipher.getUnderlyingCipher().getBlockSize();
            }

            @Override
            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    static PGPDataDecryptor createOpenPgpV6DataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        if (symmetricEncIntegrityPacket.getVersion() == 1) {
            throw new PGPException("SEIPD packet MUST be of version 2 or greater.");
        }
        final int n = symmetricEncIntegrityPacket.getCipherAlgorithm();
        final int n2 = symmetricEncIntegrityPacket.getAeadAlgorithm();
        final int n3 = symmetricEncIntegrityPacket.getChunkSize();
        final byte[] byArray = symmetricEncIntegrityPacket.getAAData();
        byte[][] byArray2 = BcAEADUtil.deriveMessageKeyAndIv(n2, n, pGPSessionKey.getKey(), symmetricEncIntegrityPacket.getSalt(), byArray);
        byte[] byArray3 = byArray2[0];
        final byte[] byArray4 = byArray2[1];
        final KeyParameter keyParameter = new KeyParameter(byArray3);
        final AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(n, n2);
        return new PGPDataDecryptor(){

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                try {
                    return new PGPAeadInputStream(false, inputStream, aEADBlockCipher, keyParameter, byArray4, n, n2, n3, byArray);
                }
                catch (IOException iOException) {
                    throw Exceptions.illegalStateException("unable to open stream: " + iOException.getMessage(), iOException);
                }
            }

            @Override
            public int getBlockSize() {
                return aEADBlockCipher.getUnderlyingCipher().getBlockSize();
            }

            @Override
            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    static byte[] processAEADData(boolean bl, int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n3, int n4, String string) throws PGPException {
        AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(n, n2);
        try {
            return BcAEADUtil.processAEADData(bl, aEADBlockCipher, new KeyParameter(byArray), byArray2, byArray3, byArray4, n3, n4);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException(string, invalidCipherTextException);
        }
    }

    static byte[] processAEADData(boolean bl, AEADBlockCipher aEADBlockCipher, KeyParameter keyParameter, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2) throws InvalidCipherTextException {
        aEADBlockCipher.init(bl, new AEADParameters(keyParameter, 128, byArray, byArray2));
        int n3 = aEADBlockCipher.getOutputSize(n2);
        byte[] byArray4 = new byte[n3];
        n3 = aEADBlockCipher.processBytes(byArray3, n, n2, byArray4, 0);
        aEADBlockCipher.doFinal(byArray4, n3);
        return byArray4;
    }

    static byte[] processAeadKeyData(boolean bl, int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6, byte[] byArray4) throws PGPException {
        byte[] byArray5 = BcAEADUtil.generateHKDFBytes(byArray, null, new byte[]{(byte)(0xC0 | n3), (byte)n4, (byte)n, (byte)n2}, SymmetricKeyUtils.getKeyLengthInOctets(n));
        byte[] byArray6 = Arrays.prepend(byArray4, (byte)(0xC0 | n3));
        return BcAEADUtil.processAEADData(bl, n, n2, byArray5, byArray2, byArray6, byArray3, n5, n6, ProcessAeadKeyDataErrorMessage);
    }

    private static interface Engine {
        public BlockCipher newInstance();
    }

    protected static class PGPAeadInputStream
    extends InputStream {
        private final InputStream in;
        private final byte[] buf;
        private final AEADBlockCipher c;
        private final KeyParameter secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private final int tagLen;
        private byte[] data;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;
        private final boolean isV5StyleAEAD;

        public PGPAeadInputStream(boolean bl, InputStream inputStream, AEADBlockCipher aEADBlockCipher, KeyParameter keyParameter, byte[] byArray, int n, int n2, int n3, byte[] byArray2) throws IOException {
            this.isV5StyleAEAD = bl;
            this.in = inputStream;
            this.iv = byArray;
            this.chunkLength = (int)BcAEADUtil.getChunkLength(n3);
            this.tagLen = AEADUtils.getAuthTagLength(n2);
            this.buf = new byte[this.chunkLength + this.tagLen + this.tagLen];
            this.c = aEADBlockCipher;
            this.secretKey = keyParameter;
            this.aaData = byArray2;
            Streams.readFully(inputStream, this.buf, 0, this.tagLen + this.tagLen);
            this.data = this.readBlock();
            this.dataOff = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data[this.dataOff++] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            int n3 = Math.min(n2, this.available());
            System.arraycopy(this.data, this.dataOff, byArray, n, n3);
            this.dataOff += n3;
            return n3;
        }

        @Override
        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            int n = (int)Math.min(l, (long)this.available());
            this.dataOff += n;
            return n;
        }

        @Override
        public int available() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.length - this.dataOff;
        }

        private byte[] readBlock() throws IOException {
            byte[] byArray;
            int n = Streams.readFully(this.in, this.buf, this.tagLen + this.tagLen, this.chunkLength);
            if (n == 0) {
                return null;
            }
            byte[] byArray2 = new byte[this.isV5StyleAEAD ? 13 : this.aaData.length];
            System.arraycopy(this.aaData, 0, byArray2, 0, this.aaData.length);
            if (this.isV5StyleAEAD) {
                BcAEADUtil.xorChunkId(byArray2, this.chunkIndex);
            }
            try {
                byArray = BcAEADUtil.processAEADData(false, this.c, this.secretKey, BcAEADUtil.getNonce(this.iv, this.chunkIndex), byArray2, this.buf, 0, n + this.tagLen);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + invalidCipherTextException.getMessage());
            }
            this.totalBytes += (long)byArray.length;
            ++this.chunkIndex;
            System.arraycopy(this.buf, n + this.tagLen, this.buf, 0, this.tagLen);
            if (n != this.chunkLength) {
                byArray2 = PGPAeadInputStream.getAdata(this.isV5StyleAEAD, this.aaData, this.chunkIndex, this.totalBytes);
                try {
                    this.c.init(false, new AEADParameters(this.secretKey, 128, BcAEADUtil.getNonce(this.iv, this.chunkIndex), byArray2));
                    if (this.isV5StyleAEAD) {
                        this.c.processAADBytes(Pack.longToBigEndian(this.totalBytes), 0, 8);
                    }
                    this.c.processBytes(this.buf, 0, this.tagLen, this.buf, 0);
                    this.c.doFinal(this.buf, 0);
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new IOException("exception processing final tag: " + invalidCipherTextException.getMessage());
                }
            } else {
                Streams.readFully(this.in, this.buf, this.tagLen, this.tagLen);
            }
            return byArray;
        }

        private static byte[] getAdata(boolean bl, byte[] byArray, long l, long l2) {
            byte[] byArray2;
            if (bl) {
                byArray2 = new byte[13];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                BcAEADUtil.xorChunkId(byArray2, l);
            } else {
                byArray2 = new byte[byArray.length + 8];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                System.arraycopy(Pack.longToBigEndian(l2), 0, byArray2, byArray.length, 8);
            }
            return byArray2;
        }
    }

    protected static class PGPAeadOutputStream
    extends OutputStream {
        private final boolean isV5StyleAEAD;
        private final OutputStream out;
        private final byte[] data;
        private final AEADBlockCipher c;
        private final KeyParameter secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private final int tagLen;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadOutputStream(boolean bl, OutputStream outputStream, AEADBlockCipher aEADBlockCipher, KeyParameter keyParameter, byte[] byArray, int n, int n2, int n3) {
            this.isV5StyleAEAD = bl;
            this.out = outputStream;
            this.iv = byArray;
            this.chunkLength = (int)BcAEADUtil.getChunkLength(n3);
            this.tagLen = AEADUtils.getAuthTagLength(n2);
            this.data = new byte[this.chunkLength];
            this.c = aEADBlockCipher;
            this.secretKey = keyParameter;
            this.aaData = this.createAAD(bl, n, n2, n3);
        }

        private byte[] createAAD(boolean bl, int n, int n2, int n3) {
            if (bl) {
                return AEADEncDataPacket.createAAData(1, n, n2, n3);
            }
            return SymmetricEncIntegrityPacket.createAAData(2, n, n2, n3);
        }

        @Override
        public void write(int n) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            this.data[this.dataOff++] = (byte)n;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            if (n2 < this.data.length - this.dataOff) {
                System.arraycopy(byArray, n, this.data, this.dataOff, n2);
                this.dataOff += n2;
            } else {
                int n3 = this.data.length - this.dataOff;
                System.arraycopy(byArray, n, this.data, this.dataOff, n3);
                this.dataOff += n3;
                this.writeBlock();
                n2 -= n3;
                n += n3;
                while (n2 >= this.data.length) {
                    System.arraycopy(byArray, n, this.data, 0, this.data.length);
                    this.dataOff = this.data.length;
                    this.writeBlock();
                    n2 -= this.data.length;
                    n += this.data.length;
                }
                if (n2 > 0) {
                    System.arraycopy(byArray, n, this.data, 0, n2);
                    this.dataOff = n2;
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }

        private void writeBlock() throws IOException {
            boolean bl = this.isV5StyleAEAD;
            byte[] byArray = bl ? new byte[13] : new byte[this.aaData.length];
            System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
            if (bl) {
                BcAEADUtil.xorChunkId(byArray, this.chunkIndex);
            }
            try {
                this.c.init(true, new AEADParameters(this.secretKey, 128, BcAEADUtil.getNonce(this.iv, this.chunkIndex), byArray));
                int n = this.c.processBytes(this.data, 0, this.dataOff, this.data, 0);
                this.out.write(this.data, 0, n);
                n = this.c.doFinal(this.data, 0);
                this.out.write(this.data, 0, n);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + invalidCipherTextException.getMessage());
            }
            this.totalBytes += (long)this.dataOff;
            ++this.chunkIndex;
            this.dataOff = 0;
        }

        private void finish() throws IOException {
            if (this.dataOff > 0) {
                this.writeBlock();
            }
            boolean bl = this.isV5StyleAEAD;
            byte[] byArray = PGPAeadInputStream.getAdata(bl, this.aaData, this.chunkIndex, this.totalBytes);
            try {
                this.c.init(true, new AEADParameters(this.secretKey, 128, BcAEADUtil.getNonce(this.iv, this.chunkIndex), byArray));
                if (bl) {
                    this.c.processAADBytes(Pack.longToBigEndian(this.totalBytes), 0, 8);
                }
                this.c.doFinal(this.data, 0);
                this.out.write(this.data, 0, this.tagLen);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new IOException("exception processing final tag: " + invalidCipherTextException.getMessage());
            }
            this.out.close();
        }
    }
}

