/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.vafer.jdeb.utils.VariableResolver;

public final class MapVariableResolver
implements VariableResolver {
    private final Map<String, String> map;

    public MapVariableResolver(Map<String, String> map) {
        this.map = map;
    }

    @Override
    public String get(String key) {
        return this.map.get(key);
    }

    public static MapVariableResolverBuilder builder() {
        return new MapVariableResolverBuilder();
    }

    public static class MapVariableResolverBuilder {
        private String name;
        private MavenProject mavenProject;
        private Properties systemProperties;
        private String buildDirectory;
        private String version;

        public MapVariableResolverBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public MapVariableResolverBuilder withMavenProject(MavenProject project) {
            this.mavenProject = project;
            return this;
        }

        public MapVariableResolverBuilder withSystemProperties(Properties properties) {
            this.systemProperties = properties;
            return this;
        }

        public MapVariableResolverBuilder withBuildDirectory(String directory) {
            this.buildDirectory = directory;
            return this;
        }

        public MapVariableResolverBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public MapVariableResolver build() {
            if (this.mavenProject == null || this.systemProperties == null) {
                throw new IllegalStateException("MavenProject and system properties must be set");
            }
            HashMap<String, String> variables = new HashMap<String, String>();
            HashMap<Object, Object> combinedProperties = new HashMap<Object, Object>();
            combinedProperties.putAll(this.mavenProject.getProperties());
            combinedProperties.putAll(this.systemProperties);
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            for (Map.Entry entry : combinedProperties.entrySet()) {
                interpolator.addValueSource((ValueSource)new MapBasedValueSource(combinedProperties));
                try {
                    String expandedValue = interpolator.interpolate((String)entry.getValue(), "");
                    variables.put((String)entry.getKey(), expandedValue);
                }
                catch (InterpolationException e) {
                    variables.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            variables.put("name", this.name != null ? this.name : this.mavenProject.getName());
            variables.put("artifactId", this.mavenProject.getArtifactId());
            variables.put("groupId", this.mavenProject.getGroupId());
            variables.put("version", this.version);
            variables.put("description", this.mavenProject.getDescription());
            variables.put("extension", "deb");
            variables.put("baseDir", this.mavenProject.getBasedir().getAbsolutePath());
            variables.put("buildDir", this.buildDirectory);
            variables.put("project.version", this.mavenProject.getVersion());
            if (this.mavenProject.getInceptionYear() != null) {
                variables.put("project.inceptionYear", this.mavenProject.getInceptionYear());
            }
            if (this.mavenProject.getOrganization() != null) {
                if (this.mavenProject.getOrganization().getName() != null) {
                    variables.put("project.organization.name", this.mavenProject.getOrganization().getName());
                }
                if (this.mavenProject.getOrganization().getUrl() != null) {
                    variables.put("project.organization.url", this.mavenProject.getOrganization().getUrl());
                }
            }
            variables.put("url", this.mavenProject.getUrl());
            return new MapVariableResolver(variables);
        }
    }
}

