/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.producers.Producers;
import org.vafer.jdeb.shaded.compress.compress.archivers.tar.TarArchiveEntry;

public abstract class AbstractDataProducer
implements DataProducer {
    private final String[] includes;
    private final String[] excludes;
    private final Mapper[] mappers;

    public AbstractDataProducer(String[] pIncludes, String[] pExcludes, Mapper[] pMapper) {
        String[] stringArray;
        String[] stringArray2 = this.excludes = pExcludes != null ? pExcludes : new String[]{};
        if (pIncludes != null) {
            stringArray = pIncludes;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "**";
        }
        this.includes = stringArray;
        this.mappers = pMapper != null ? pMapper : new Mapper[]{};
    }

    public boolean isIncluded(String pName) {
        if (!this.isIncluded(pName, this.includes)) {
            return false;
        }
        return !this.isExcluded(pName, this.excludes);
    }

    private boolean isIncluded(String name, String[] includes) {
        for (String include : includes) {
            if (!SelectorUtils.matchPath((String)include, (String)name)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(String name, String[] excludes) {
        for (String exclude : excludes) {
            if (!SelectorUtils.matchPath((String)exclude, (String)name)) continue;
            return true;
        }
        return false;
    }

    public void produceDir(DataConsumer consumer, String dirname) throws IOException {
        TarArchiveEntry entry = Producers.defaultDirEntryWithName(dirname);
        entry = this.map(entry);
        entry.setSize(0L);
        Producers.produceDirEntry(consumer, entry);
    }

    public void produceFile(DataConsumer consumer, File file, String entryName) throws IOException {
        TarArchiveEntry entry = Producers.defaultFileEntryWithName(entryName);
        entry.setSize(file.length());
        entry = this.map(entry);
        Producers.produceInputStreamWithEntry(consumer, new FileInputStream(file), entry);
    }

    public TarArchiveEntry map(TarArchiveEntry pEntry) {
        TarArchiveEntry entry = pEntry;
        for (Mapper mapper : this.mappers) {
            entry = mapper.map(entry);
        }
        return entry;
    }
}

