/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.crypto.signers;

import java.io.IOException;
import java.math.BigInteger;
import org.vafer.jdeb.shaded.bc.asn1.ASN1EncodableVector;
import org.vafer.jdeb.shaded.bc.asn1.ASN1Primitive;
import org.vafer.jdeb.shaded.bc.asn1.ASN1Sequence;
import org.vafer.jdeb.shaded.bc.asn1.DERInteger;
import org.vafer.jdeb.shaded.bc.asn1.DERSequence;
import org.vafer.jdeb.shaded.bc.crypto.CipherParameters;
import org.vafer.jdeb.shaded.bc.crypto.DSA;
import org.vafer.jdeb.shaded.bc.crypto.Digest;
import org.vafer.jdeb.shaded.bc.crypto.Signer;
import org.vafer.jdeb.shaded.bc.crypto.params.AsymmetricKeyParameter;
import org.vafer.jdeb.shaded.bc.crypto.params.ParametersWithRandom;

public class DSADigestSigner
implements Signer {
    private final Digest digest;
    private final DSA dsaSigner;
    private boolean forSigning;

    public DSADigestSigner(DSA dSA, Digest digest) {
        this.digest = digest;
        this.dsaSigner = dSA;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!bl && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.dsaSigner.init(bl, cipherParameters);
    }

    public void update(byte by) {
        this.digest.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public byte[] generateSignature() {
        if (!this.forSigning) {
            throw new IllegalStateException("DSADigestSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        BigInteger[] bigIntegerArray = this.dsaSigner.generateSignature(byArray);
        try {
            return this.derEncode(bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode signature");
        }
    }

    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning) {
            throw new IllegalStateException("DSADigestSigner not initialised for verification");
        }
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        try {
            BigInteger[] bigIntegerArray = this.derDecode(byArray);
            return this.dsaSigner.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void reset() {
        this.digest.reset();
    }

    private byte[] derEncode(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(bigInteger));
        aSN1EncodableVector.add(new DERInteger(bigInteger2));
        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
    }

    private BigInteger[] derDecode(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        return new BigInteger[]{((DERInteger)aSN1Sequence.getObjectAt(0)).getValue(), ((DERInteger)aSN1Sequence.getObjectAt(1)).getValue()};
    }
}

