/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import org.vafer.jdeb.shaded.bc.jcajce.DefaultJcaJceHelper;
import org.vafer.jdeb.shaded.bc.jcajce.NamedJcaJceHelper;
import org.vafer.jdeb.shaded.bc.jcajce.ProviderJcaJceHelper;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPublicKey;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPContentVerifier;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPContentVerifierBuilder;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.OperatorHelper;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.SignatureOutputStream;

public class JcaPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcaPGPContentVerifierBuilderProvider setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcaPGPContentVerifierBuilderProvider setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        return this;
    }

    public PGPContentVerifierBuilder get(int n, int n2) throws PGPException {
        return new JcaPGPContentVerifierBuilder(n, n2);
    }

    private class JcaPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public JcaPGPContentVerifierBuilder(int n, int n2) {
            this.keyAlgorithm = n;
            this.hashAlgorithm = n2;
        }

        public PGPContentVerifier build(final PGPPublicKey pGPPublicKey) throws PGPException {
            final Signature signature = JcaPGPContentVerifierBuilderProvider.this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
            try {
                signature.initVerify(JcaPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(pGPPublicKey));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PGPException("invalid key.", invalidKeyException);
            }
            return new PGPContentVerifier(){

                public int getHashAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.hashAlgorithm;
                }

                public int getKeyAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.keyAlgorithm;
                }

                public long getKeyID() {
                    return pGPPublicKey.getKeyID();
                }

                public boolean verify(byte[] byArray) {
                    try {
                        return signature.verify(byArray);
                    }
                    catch (SignatureException signatureException) {
                        throw new IllegalStateException("unable to verify signature");
                    }
                }

                public OutputStream getOutputStream() {
                    return new SignatureOutputStream(signature);
                }
            };
        }
    }
}

