/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.vafer.jdeb.shaded.bc.asn1.nist.NISTNamedCurves;
import org.vafer.jdeb.shaded.bc.asn1.x9.X9ECParameters;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ECDHPublicBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.ECSecretBCPGKey;
import org.vafer.jdeb.shaded.bc.bcpg.PublicKeyPacket;
import org.vafer.jdeb.shaded.bc.crypto.params.ECDomainParameters;
import org.vafer.jdeb.shaded.bc.jcajce.DefaultJcaJceHelper;
import org.vafer.jdeb.shaded.bc.jcajce.NamedJcaJceHelper;
import org.vafer.jdeb.shaded.bc.jcajce.ProviderJcaJceHelper;
import org.vafer.jdeb.shaded.bc.jce.interfaces.ElGamalKey;
import org.vafer.jdeb.shaded.bc.math.ec.ECPoint;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPrivateKey;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PGPDataDecryptor;
import org.vafer.jdeb.shaded.bc.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.vafer.jdeb.shaded.bc.openpgp.operator.RFC6637KDFCalculator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.OperatorHelper;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.PGPUtil;

public class JcePublicKeyDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private OperatorHelper contentHelper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private JcaPGPDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    private JcaKeyFingerprintCalculator fingerprintCalculator = new JcaKeyFingerprintCalculator();

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.contentHelper = this.helper;
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        this.contentHelper = this.helper;
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(Provider provider) {
        this.contentHelper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(String string) {
        this.contentHelper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public PublicKeyDataDecryptorFactory build(final PrivateKey privateKey) {
        return new PublicKeyDataDecryptorFactory(){

            public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
                if (n == 18) {
                    throw new PGPException("ECDH requires use of PGPPrivateKey for decryption");
                }
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(n, privateKey, byArray);
            }

            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(bl, n, byArray);
            }
        };
    }

    public PublicKeyDataDecryptorFactory build(final PGPPrivateKey pGPPrivateKey) {
        return new PublicKeyDataDecryptorFactory(){

            public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
                if (n == 18) {
                    return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(pGPPrivateKey.getPrivateKeyDataPacket(), pGPPrivateKey.getPublicKeyPacket(), byArray);
                }
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(n, JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter.getPrivateKey(pGPPrivateKey), byArray);
            }

            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(bl, n, byArray);
            }
        };
    }

    private byte[] decryptSessionData(BCPGKey bCPGKey, PublicKeyPacket publicKeyPacket, byte[][] byArray) throws PGPException {
        ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
        X9ECParameters x9ECParameters = NISTNamedCurves.getByOID(eCDHPublicBCPGKey.getCurveOID());
        ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
        byte[] byArray2 = byArray[0];
        int n = (((byArray2[0] & 0xFF) << 8) + (byArray2[1] & 0xFF) + 7) / 8;
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 2, byArray3, 0, n);
        byte[] byArray4 = new byte[byArray2[n + 2]];
        System.arraycopy(byArray2, 2 + n + 1, byArray4, 0, byArray4.length);
        Cipher cipher = this.helper.createKeyWrapper(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
        ECPoint eCPoint = x9ECParameters.getCurve().decodePoint(byArray3).multiply(((ECSecretBCPGKey)bCPGKey).getX()).normalize();
        RFC6637KDFCalculator rFC6637KDFCalculator = new RFC6637KDFCalculator(this.digestCalculatorProviderBuilder.build().get(eCDHPublicBCPGKey.getHashAlgorithm()), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
        SecretKeySpec secretKeySpec = new SecretKeySpec(rFC6637KDFCalculator.createKey(eCDHPublicBCPGKey.getCurveOID(), eCPoint, this.fingerprintCalculator.calculateFingerprint(publicKeyPacket)), "AESWrap");
        try {
            cipher.init(4, secretKeySpec);
            Key key = cipher.unwrap(byArray4, "Session", 3);
            return PGPUtil.unpadSessionData(key.getEncoded());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PGPException("error setting asymmetric cipher", noSuchAlgorithmException);
        }
    }

    private byte[] decryptSessionData(int n, PrivateKey privateKey, byte[][] byArray) throws PGPException {
        Object object;
        Cipher cipher = this.helper.createPublicKeyCipher(n);
        try {
            cipher.init(2, privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        if (n == 2 || n == 1) {
            object = byArray[0];
            cipher.update((byte[])object, 2, ((Object)object).length - 2);
        } else {
            object = (ElGamalKey)((Object)privateKey);
            int n2 = (object.getParameters().getP().bitLength() + 7) / 8;
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = byArray[0];
            if (byArray3.length - 2 > n2) {
                cipher.update(byArray3, 3, byArray3.length - 3);
            } else {
                System.arraycopy(byArray3, 2, byArray2, byArray2.length - (byArray3.length - 2), byArray3.length - 2);
                cipher.update(byArray2);
            }
            byArray3 = byArray[1];
            for (int i = 0; i != byArray2.length; ++i) {
                byArray2[i] = 0;
            }
            if (byArray3.length - 2 > n2) {
                cipher.update(byArray3, 3, byArray3.length - 3);
            } else {
                System.arraycopy(byArray3, 2, byArray2, byArray2.length - (byArray3.length - 2), byArray3.length - 2);
                cipher.update(byArray2);
            }
        }
        try {
            return cipher.doFinal();
        }
        catch (Exception exception) {
            throw new PGPException("exception decrypting session data", exception);
        }
    }
}

