/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SignatureException;
import org.vafer.jdeb.shaded.bc.bcpg.ArmoredOutputStream;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignature;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignatureGenerator;

public class PGPSignatureOutputStream
extends OutputStream {
    private final PGPSignatureGenerator signatureGenerator;

    public PGPSignatureOutputStream(PGPSignatureGenerator signatureGenerator) {
        this.signatureGenerator = signatureGenerator;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.signatureGenerator.update(new byte[]{(byte)b});
        }
        catch (SignatureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.signatureGenerator.update(b);
        }
        catch (SignatureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.signatureGenerator.update(b, off, len);
        }
        catch (SignatureException e) {
            throw new IOException(e);
        }
    }

    public PGPSignature generateSignature() throws SignatureException, PGPException {
        return this.signatureGenerator.generate();
    }

    public String generateASCIISignature() throws SignatureException, PGPException {
        try {
            PGPSignature signature = this.generateSignature();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ArmoredOutputStream armorStream = new ArmoredOutputStream(buffer);
            signature.encode(armorStream);
            armorStream.close();
            return new String(buffer.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

