/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.datasources;

import java.io.IOException;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddJdbcDriver
implements OnlineCommand,
OfflineCommand {
    private final String driverName;
    private final String driverClass;
    private final String datasourceClass;
    private final String xaDatasourceClass;
    private final String module;
    private final String moduleSlot;

    private AddJdbcDriver(Builder builder) {
        this.driverName = builder.driverName;
        this.driverClass = builder.driverClass;
        this.datasourceClass = builder.datasourceClass;
        this.xaDatasourceClass = builder.xaDatasourceClass;
        this.module = builder.module;
        this.moduleSlot = builder.moduleSlot;
    }

    public void apply(OnlineCommandContext ctx) throws IOException {
        Operations ops = new Operations(ctx.client);
        ops.add(Address.subsystem((String)"datasources").and("jdbc-driver", this.driverName), Values.empty().and("driver-name", this.driverName).and("driver-module-name", this.module).andOptional("module-slot", this.moduleSlot).andOptional("driver-class-name", this.driverClass).andOptional("driver-datasource-class-name", this.datasourceClass).andOptional("driver-xa-datasource-class-name", this.xaDatasourceClass));
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException {
        GroovyXmlTransform transform = GroovyXmlTransform.of(AddJdbcDriver.class).subtree("datasources", Subtree.subsystem("datasources")).parameter("driverName", this.driverName).parameter("module", this.module).parameter("moduleSlot", this.moduleSlot).parameter("driverClass", this.driverClass).parameter("datasourceClass", this.datasourceClass).parameter("xaDatasourceClass", this.xaDatasourceClass).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "AddJdbcDriver " + this.driverName;
    }

    public static final class Builder {
        private String driverName;
        private String driverClass;
        private String datasourceClass;
        private String xaDatasourceClass;
        private String module;
        private String moduleSlot;

        public Builder(String driverName, String module) {
            if (driverName == null) {
                throw new IllegalArgumentException("Name of the JDBC driver must be specified as non null value");
            }
            if (module == null) {
                throw new IllegalArgumentException("Name of the module must be specified as non null value");
            }
            this.driverName = driverName;
            this.module = module;
        }

        public Builder driverClass(String driverClass) {
            this.driverClass = driverClass;
            return this;
        }

        public Builder datasourceClass(String datasourceClass) {
            this.datasourceClass = datasourceClass;
            return this;
        }

        public Builder xaDatasourceClass(String xaDatasourceClass) {
            this.xaDatasourceClass = xaDatasourceClass;
            return this;
        }

        public Builder moduleSlot(String moduleSlot) {
            this.moduleSlot = moduleSlot;
            return this;
        }

        public AddJdbcDriver build() {
            return new AddJdbcDriver(this);
        }
    }
}

