/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.messaging;

import java.io.IOException;
import java.util.List;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.messaging.MessagingUtils;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddTopic
implements OnlineCommand,
OfflineCommand {
    private final String name;
    private final String serverName;
    private List<String> jndiEntries;
    private final boolean replaceExisting;

    private AddTopic(Builder builder) {
        this.name = builder.name;
        this.serverName = builder.serverName;
        this.jndiEntries = builder.jndiEntries;
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws IOException, CommandFailedException {
        Operations ops = new Operations(ctx.client);
        Address address = MessagingUtils.address(ctx.client, this.serverName).and("jms-topic", this.name);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(address);
            }
            catch (OperationException e) {
                throw new CommandFailedException("Failed to remove existing topic " + this.name, (Throwable)e);
            }
        }
        ops.add(address, Values.empty().andList(String.class, "entries", this.jndiEntries));
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
        if (!"default".equals(this.serverName)) {
            throw new CommandFailedException("Non-default messaging server name not yet implemented in offline mode");
        }
        GroovyXmlTransform transform = GroovyXmlTransform.of(AddTopic.class).subtree("messagingHornetq", Subtree.subsystem("messaging")).subtree("messagingActivemq", Subtree.subsystem("messaging-activemq")).parameter("name", this.name).parameter("entries", this.jndiEntries).parameter("entriesString", MessagingUtils.getStringOfEntries(this.jndiEntries)).parameter("replaceExisting", this.replaceExisting).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "AddTopic " + this.name;
    }

    public static final class Builder {
        private final String name;
        private final String serverName;
        private List<String> jndiEntries;
        private boolean replaceExisting;

        public Builder(String name) {
            this(name, "default");
        }

        public Builder(String name, String serverName) {
            if (name == null) {
                throw new IllegalArgumentException("Topic name must be specified as non null value");
            }
            if (serverName == null) {
                throw new IllegalArgumentException("Messaging server name must be specified as non null value");
            }
            this.name = name;
            this.serverName = serverName;
        }

        public Builder jndiEntries(List<String> jndiEntries) {
            this.jndiEntries = jndiEntries;
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public AddTopic build() {
            this.check();
            return new AddTopic(this);
        }

        private void check() {
            if (this.jndiEntries == null || this.jndiEntries.isEmpty()) {
                throw new IllegalArgumentException("At least one jndi entry needs to be specified for topic");
            }
        }
    }
}

