/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.messaging;

import java.io.IOException;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.messaging.MessagingUtils;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class RemoveTopic
implements OnlineCommand,
OfflineCommand {
    private final String topicName;
    private final String serverName;

    public RemoveTopic(String topicName) {
        this(topicName, "default");
    }

    public RemoveTopic(String topicName, String serverName) {
        if (topicName == null) {
            throw new IllegalArgumentException("Name of the topic must be specified as non null value");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Server name must be specified as non null value");
        }
        this.topicName = topicName;
        this.serverName = serverName;
    }

    public void apply(OnlineCommandContext ctx) throws IOException, CommandFailedException {
        Operations ops = new Operations(ctx.client);
        ops.remove(MessagingUtils.address(ctx.client, this.serverName).and("jms-topic", this.topicName));
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException {
        if (!"default".equals(this.serverName)) {
            throw new CommandFailedException("Non-default messaging server name not yet implemented in offline mode");
        }
        GroovyXmlTransform transform = GroovyXmlTransform.of(RemoveTopic.class).subtree("messagingHornetq", Subtree.subsystem("messaging")).subtree("messagingActivemq", Subtree.subsystem("messaging-activemq")).parameter("topicName", this.topicName).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "RemoveTopic " + this.topicName;
    }
}

