/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security.realms;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.security.realms.AbstractAddSecurityRealmSubElement;
import org.wildfly.extras.creaper.commands.security.realms.KerberosKeytab;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddKerberosAuthentication
extends AbstractAddSecurityRealmSubElement {
    private final Boolean removeRealm;
    private final List<KerberosKeytab> keytabs;

    private AddKerberosAuthentication(Builder builder) {
        super(builder);
        this.removeRealm = builder.removeRealm;
        this.keytabs = builder.keytabs;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        boolean krbServerIdentityExists;
        Batch batch;
        if (ctx.version.lessThan(ServerVersion.VERSION_1_7_0) || ctx.version.inRange(ServerVersion.VERSION_2_0_0, ServerVersion.VERSION_2_2_0)) {
            throw new AssertionError((Object)"Kerberos authentication in security realm is available since WildFly 9 or in EAP 6.4.x.");
        }
        Operations ops = new Operations(ctx.client);
        Address securityServerIdentitiesAddress = this.securityRealmAddress.and("server-identity", "kerberos");
        Address securityRealmKerberosAuthnAddress = this.securityRealmAddress.and("authentication", "kerberos");
        if (this.replaceExisting) {
            boolean krbAuthenticationExists;
            batch = new Batch();
            krbServerIdentityExists = ops.exists(securityServerIdentitiesAddress);
            if (krbServerIdentityExists) {
                batch.remove(securityServerIdentitiesAddress);
            }
            if (krbAuthenticationExists = ops.exists(securityRealmKerberosAuthnAddress)) {
                batch.remove(securityRealmKerberosAuthnAddress);
            }
            ops.batch(batch);
            new Administration(ctx.client).reloadIfRequired();
        }
        batch = new Batch();
        krbServerIdentityExists = ops.exists(securityServerIdentitiesAddress);
        if (!krbServerIdentityExists) {
            batch.add(securityServerIdentitiesAddress);
        }
        for (KerberosKeytab keytab : this.keytabs) {
            batch.add(securityServerIdentitiesAddress.and("keytab", keytab.getPrincipal()), Values.empty().andOptional("path", keytab.getPath()).andOptional("relative-to", keytab.getRelativeTo()).andListOptional(String.class, "for-hosts", keytab.getForHosts()).andOptional("debug", keytab.getDebug()));
        }
        batch.add(securityRealmKerberosAuthnAddress, Values.empty().andOptional("remove-realm", this.removeRealm));
        ops.batch(batch);
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        if (ctx.version.lessThan(ServerVersion.VERSION_1_7_0) || ctx.version.inRange(ServerVersion.VERSION_2_0_0, ServerVersion.VERSION_2_2_0)) {
            throw new AssertionError((Object)"Kerberos authentication in security realm is available since WildFly 9 or in EAP 6.4.x.");
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddKerberosAuthentication.class).subtree("management", Subtree.management()).parameter("atrSecurityRealmName", this.securityRealmName).parameter("atrRemoveRealm", this.removeRealm).parameter("atrKeytabs", this.keytabs).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class Builder
    extends AbstractAddSecurityRealmSubElement.Builder<Builder> {
        private Boolean removeRealm;
        private List<KerberosKeytab> keytabs = new ArrayList<KerberosKeytab>();

        public Builder(String securityRealmName) {
            super(securityRealmName);
        }

        public Builder removeRealm(boolean removeRealm) {
            this.removeRealm = removeRealm;
            return this;
        }

        public Builder addKeytab(KerberosKeytab keytab) {
            this.keytabs.add(keytab);
            return this;
        }

        @Override
        public AddKerberosAuthentication build() {
            if (this.keytabs.size() < 1) {
                throw new IllegalArgumentException("At least one keytab has to be defined.");
            }
            return new AddKerberosAuthentication(this);
        }
    }
}

