/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.transactions;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class ChangeJdbcTransactionAttributes
implements OfflineCommand,
OnlineCommand {
    private final Boolean useJdbcStore;
    private final Boolean actionStoreDropTable;
    private final String actionStoreTablePrefix;
    private final Boolean communicationStoreDropTable;
    private final String communicationStoreTablePrefix;
    private final String stateStoreTablePrefix;
    private final String storeDatasource;
    private final Boolean stateStoreDropTable;

    private ChangeJdbcTransactionAttributes(Builder builder) {
        this.useJdbcStore = builder.useJdbcStore;
        this.actionStoreDropTable = builder.actionStoreDropTable;
        this.actionStoreTablePrefix = builder.actionStoreTablePrefix;
        this.communicationStoreDropTable = builder.communicationStoreDropTable;
        this.communicationStoreTablePrefix = builder.communicationStoreTablePrefix;
        this.stateStoreTablePrefix = builder.stateStoreTablePrefix;
        this.storeDatasource = builder.storeDatasource;
        this.stateStoreDropTable = builder.stateStoreDropTable;
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        ctx.version.assertAtLeast(ServerVersion.VERSION_2_0_0, "JDBC options are available only for WildFly 8 and higher");
        GroovyXmlTransform transform = GroovyXmlTransform.of(ChangeJdbcTransactionAttributes.class).subtree("transactions", Subtree.subsystem("transactions")).parameter("useJdbcStore", this.useJdbcStore != null ? String.valueOf(this.useJdbcStore) : null).parameter("storeDatasource", this.storeDatasource).parameter("actionStoreDropTable", this.actionStoreDropTable != null ? String.valueOf(this.actionStoreDropTable) : null).parameter("actionStoreTablePrefix", this.actionStoreTablePrefix).parameter("communicationStoreDropTable", this.communicationStoreDropTable != null ? String.valueOf(this.communicationStoreDropTable) : null).parameter("communicationStoreTablePrefix", this.communicationStoreTablePrefix).parameter("stateStoreDropTable", this.stateStoreDropTable != null ? String.valueOf(this.stateStoreDropTable) : null).parameter("stateStoreTablePrefix", this.stateStoreTablePrefix).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        ctx.version.assertAtLeast(ServerVersion.VERSION_2_0_0, "JDBC options are available only for WildFly 8 and higher");
        Batch batch = new Batch();
        Operations ops = new Operations(ctx.client);
        Address address = Address.subsystem((String)"transactions");
        if (this.useJdbcStore != null) {
            batch.writeAttribute(address, "use-jdbc-store", this.useJdbcStore.booleanValue());
        }
        if (this.storeDatasource != null) {
            batch.writeAttribute(address, "jdbc-store-datasource", this.storeDatasource);
        }
        if (this.actionStoreDropTable != null) {
            batch.writeAttribute(address, "jdbc-action-store-drop-table", this.actionStoreDropTable.booleanValue());
        }
        if (this.actionStoreTablePrefix != null) {
            batch.writeAttribute(address, "jdbc-action-store-table-prefix", this.actionStoreTablePrefix);
        }
        if (this.communicationStoreDropTable != null) {
            batch.writeAttribute(address, "jdbc-communication-store-drop-table", this.communicationStoreDropTable.booleanValue());
        }
        if (this.communicationStoreTablePrefix != null) {
            batch.writeAttribute(address, "jdbc-communication-store-table-prefix", this.communicationStoreTablePrefix);
        }
        if (this.stateStoreDropTable != null) {
            batch.writeAttribute(address, "jdbc-state-store-drop-table", this.stateStoreDropTable.booleanValue());
        }
        if (this.actionStoreTablePrefix != null) {
            batch.writeAttribute(address, "jdbc-state-store-table-prefix", this.stateStoreTablePrefix);
        }
        ops.batch(batch);
    }

    public static final class Builder {
        protected Boolean useJdbcStore;
        protected String storeDatasource;
        protected Boolean actionStoreDropTable;
        protected String actionStoreTablePrefix;
        protected Boolean communicationStoreDropTable;
        protected String communicationStoreTablePrefix;
        protected Boolean stateStoreDropTable;
        protected String stateStoreTablePrefix;

        public Builder useJdbcStore(boolean value) {
            this.useJdbcStore = value;
            return this;
        }

        public Builder storeDatasource(String value) {
            this.storeDatasource = value;
            return this;
        }

        public Builder actionStoreDropTable(boolean value) {
            this.actionStoreDropTable = value;
            return this;
        }

        public Builder actionStoreTablePrefix(String value) {
            this.actionStoreTablePrefix = value;
            return this;
        }

        public Builder communicationStoreDropTable(boolean value) {
            this.communicationStoreDropTable = value;
            return this;
        }

        public Builder communicationStoreTablePrefix(String value) {
            this.communicationStoreTablePrefix = value;
            return this;
        }

        public Builder stateStoreDropTable(boolean value) {
            this.stateStoreDropTable = value;
            return this;
        }

        public Builder stateStoreTablePrefix(String value) {
            this.stateStoreTablePrefix = value;
            return this;
        }

        public ChangeJdbcTransactionAttributes build() {
            this.validate();
            return new ChangeJdbcTransactionAttributes(this);
        }

        private void validate() {
            if (this.useJdbcStore != null && this.useJdbcStore.booleanValue() && this.storeDatasource != null && this.storeDatasource.equals("")) {
                throw new IllegalArgumentException("JDBC store datasource must be presented along with enabled using JDBC store");
            }
        }
    }
}

