/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.server;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.galleon.plugin.server.ClassLoaderHelper;

public class EmbeddedServerInvoker {
    private final MessageWriter messageWriter;
    private final Path installationDir;
    private final String serverConfig;

    public EmbeddedServerInvoker(MessageWriter messageWriter, Path installationDir, String config) {
        this.messageWriter = messageWriter;
        this.installationDir = installationDir;
        String localConfig = "standalone.xml";
        if (config != null && !config.isEmpty()) {
            localConfig = config;
        }
        this.serverConfig = localConfig;
    }

    public Path createEmbeddedStandaloneScript(List<String> commands) throws ProvisioningException {
        ArrayList<String> allCommands = new ArrayList<String>();
        allCommands.add(this.startEmbeddedServerCommand());
        allCommands.addAll(commands);
        allCommands.add("stop-embedded-server");
        try {
            Path script = Files.createTempFile("", ".cli", new FileAttribute[0]);
            Files.write(script, allCommands, new OpenOption[0]);
            return script;
        }
        catch (IOException e) {
            throw new ProvisioningException((Throwable)e);
        }
    }

    public static Path createEmbeddedHostControllerScript(String domainConfig, String hostConfig, List<String> commands) throws ProvisioningException {
        ArrayList<String> allCommands = new ArrayList<String>();
        allCommands.add(EmbeddedServerInvoker.startEmbeddedHostControllerCommand(domainConfig, hostConfig));
        allCommands.addAll(commands);
        allCommands.add("stop-embedded-host-controller");
        try {
            Path script = Files.createTempFile("", ".cli", new FileAttribute[0]);
            Files.write(script, allCommands, new OpenOption[0]);
            return script;
        }
        catch (IOException e) {
            throw new ProvisioningException((Throwable)e);
        }
    }

    public String startEmbeddedServerCommand() {
        return String.format("embed-server --admin-only --std-out=echo --server-config=%s", this.serverConfig);
    }

    public static String startEmbeddedHostControllerCommand(String domainConfig, String hostConfig) {
        String localDomainConfig = "domain.xml";
        if (domainConfig != null && !domainConfig.isEmpty()) {
            localDomainConfig = domainConfig;
        }
        String localHostConfig = "host.xml";
        if (hostConfig != null && !hostConfig.isEmpty()) {
            localHostConfig = hostConfig;
        }
        return String.format("embed-host-controller --std-out=echo --domain-config=%s --host-config=%s", localDomainConfig, localHostConfig);
    }

    public void execute(String ... commands) throws ProvisioningException {
        this.execute(Arrays.asList(commands));
    }

    public void execute(List<String> commands) throws ProvisioningException {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        URLClassLoader newCl = ClassLoaderHelper.prepareProvisioningClassLoader(this.installationDir, originalCl, new URL[0]);
        Path script = this.createEmbeddedStandaloneScript(commands);
        Properties props = System.getProperties();
        try {
            Thread.currentThread().setContextClassLoader(newCl);
            Class<?> cliScriptRunner = newCl.loadClass("org.jboss.galleon.plugin.wildfly.server.CliScriptRunner");
            Method execute = cliScriptRunner.getMethod("runCliScript", Path.class, Path.class, MessageWriter.class);
            execute.invoke(null, this.installationDir, script, this.messageWriter);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoClassDefFoundError | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ProvisioningException(ex.getMessage(), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
            System.setProperties(props);
            ClassLoaderHelper.close(newCl);
        }
    }
}

