/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.common;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Permission;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.wildfly.elytron.web.undertow.common.AbstractHttpServerMechanismTest;
import org.wildfly.elytron.web.undertow.common.UndertowServer;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.KeyStoreBackedSecurityRealm;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.x500.X500AttributePrincipalDecoder;

public abstract class ClientCertAuthenticationBase
extends AbstractHttpServerMechanismTest {
    private SecurityRealm securityRealm;
    @Rule
    public UndertowServer serverA = this.createUndertowServerA();
    @Rule
    public UndertowServer serverB = this.createUndertowServerB();
    private AtomicInteger realmIdentityInvocationCount = new AtomicInteger(0);

    protected ClientCertAuthenticationBase() throws Exception {
    }

    @Test
    public void testSuccessfulAuthentication() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLContext(this.createRecognizedSSLContext()).setSSLHostnameVerifier((h, s) -> true).build();
        this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)new HttpGet(this.serverA.createUri())), "ladybird");
    }

    @Test
    public void testClientCertAfterSession() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLContext(this.createRecognizedSSLContext()).setSSLHostnameVerifier((h, s) -> true).build();
        this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)new HttpGet(this.serverB.createUri())), "ladybird");
    }

    @Test
    public void testSSLSessionIdentityCacheHit() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().disableConnectionState().setSSLContext(this.createRecognizedSSLContext()).setSSLHostnameVerifier((h, s) -> true).build();
        this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)new HttpGet(this.serverA.createUri())), "ladybird");
        Assert.assertEquals((long)2L, (long)this.realmIdentityInvocationCount.get());
        for (int i = 0; i < 10; ++i) {
            this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)new HttpGet(this.serverA.createUri())), "ladybird");
        }
        Assert.assertEquals((long)2L, (long)this.realmIdentityInvocationCount.get());
    }

    @Test
    public void testFailedAuthentication() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLContext(this.createUnrecognizedSSLContext()).setSSLHostnameVerifier((h, s) -> true).build();
        Assert.assertEquals((long)403L, (long)httpClient.execute((HttpUriRequest)new HttpGet(this.serverA.createUri())).getStatusLine().getStatusCode());
    }

    @Override
    protected String getMechanismName() {
        return "CLIENT_CERT";
    }

    @Override
    protected SecurityDomain doCreateSecurityDomain() throws Exception {
        final KeyStoreBackedSecurityRealm delegate = new KeyStoreBackedSecurityRealm(this.loadKeyStore("/tls/beetles.keystore"));
        this.securityRealm = new SecurityRealm(){

            public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
                ClientCertAuthenticationBase.this.realmIdentityInvocationCount.incrementAndGet();
                return delegate.getRealmIdentity(principal);
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return delegate.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return delegate.getEvidenceVerifySupport(evidenceType, algorithmName);
            }
        };
        SecurityDomain.Builder builder = SecurityDomain.builder().addRealm("KeystoreRealm", this.securityRealm).build().setDefaultRealmName("KeystoreRealm").setPrincipalDecoder(PrincipalDecoder.aggregate((PrincipalDecoder[])new PrincipalDecoder[]{new X500AttributePrincipalDecoder("2.5.4.3", 1), PrincipalDecoder.DEFAULT})).setPreRealmRewriter(s -> s.toLowerCase()).setPermissionMapper((principal, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        return builder.build();
    }

    private SSLContext createRecognizedSSLContext() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[]{this.getKeyManager("/tls/ladybird.keystore")}, new TrustManager[]{this.getCATrustManager()}, null);
        return sslContext;
    }

    private SSLContext createUnrecognizedSSLContext() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[]{this.getKeyManager("/tls/tiger.keystore")}, new TrustManager[]{this.getCATrustManager()}, null);
        return sslContext;
    }

    protected X509ExtendedKeyManager getKeyManager(String keystorePath) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(this.loadKeyStore(keystorePath), "Elytron".toCharArray());
        for (KeyManager current : keyManagerFactory.getKeyManagers()) {
            if (!(current instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)current;
        }
        throw new IllegalStateException("Unable to obtain X509ExtendedKeyManager.");
    }

    protected X509TrustManager getCATrustManager() throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.loadKeyStore("/tls/ca.truststore"));
        for (TrustManager current : trustManagerFactory.getTrustManagers()) {
            if (!(current instanceof X509TrustManager)) continue;
            return (X509TrustManager)current;
        }
        throw new IllegalStateException("Unable to obtain X509TrustManager.");
    }

    private KeyStore loadKeyStore(String path) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("jks");
        try (InputStream keyStoreStream = ClientCertAuthenticationBase.class.getResourceAsStream(path);){
            Assert.assertNotNull((String)"InputStream must not be null", (Object)keyStoreStream);
            keyStore.load(keyStoreStream, "Elytron".toCharArray());
        }
        return keyStore;
    }

    protected SSLContext getSSLContext(boolean authenticate) throws GeneralSecurityException, Exception {
        SSLContextBuilder builder = new SSLContextBuilder().setSecurityDomain(this.getSecurityDomain()).setKeyManager(this.getKeyManager("/tls/scarab.keystore")).setTrustManager(this.getCATrustManager());
        if (authenticate) {
            builder.setWantClientAuth(true);
        }
        return (SSLContext)builder.build().create();
    }

    protected abstract UndertowServer createUndertowServerA() throws Exception;

    protected abstract UndertowServer createUndertowServerB() throws Exception;
}

