/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.sasl.entity.EntitySaslClient;

public final class EntitySaslClientFactory
implements SaslClientFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Signature signature;
        String name;
        boolean mutual;
        boolean serverAuth = props != null && Boolean.parseBoolean(String.valueOf(props.get("javax.security.sasl.server.authentication")));
        String[] stringArray = mechanisms;
        int n = stringArray.length;
        int n2 = 0;
        block24: while (true) {
            if (n2 >= n) {
                return null;
            }
            String mechanism = stringArray[n2];
            mutual = false;
            switch (mechanism) {
                case "9798-M-RSA-SHA1-ENC": {
                    mutual = true;
                }
                case "9798-U-RSA-SHA1-ENC": {
                    if (serverAuth && !mutual) break;
                    name = mechanism;
                    try {
                        signature = Signature.getInstance("SHA1withRSA");
                        break block24;
                    }
                    catch (NoSuchAlgorithmException e) {
                        break;
                    }
                }
                case "9798-M-DSA-SHA1": {
                    mutual = true;
                }
                case "9798-U-DSA-SHA1": {
                    if (serverAuth && !mutual) break;
                    name = mechanism;
                    try {
                        signature = Signature.getInstance("SHA1withDSA");
                        break block24;
                    }
                    catch (NoSuchAlgorithmException e) {
                        break;
                    }
                }
                case "9798-M-ECDSA-SHA1": {
                    mutual = true;
                }
                case "9798-U-ECDSA-SHA1": {
                    if (serverAuth && !mutual) break;
                    name = mechanism;
                    try {
                        signature = Signature.getInstance("SHA1withECDSA");
                        break block24;
                    }
                    catch (NoSuchAlgorithmException e) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        Object rngNameValue = props == null ? null : props.get("wildfly.sasl.secure-rng");
        String rngName = rngNameValue instanceof String ? (String)rngNameValue : null;
        SecureRandom secureRandom = null;
        if (rngName != null) {
            try {
                secureRandom = SecureRandom.getInstance(rngName);
            }
            catch (NoSuchAlgorithmException mechanism) {
                // empty catch block
            }
        }
        EntitySaslClient client = new EntitySaslClient(name, mutual, signature, secureRandom, protocol, serverName, cbh, authorizationId);
        client.init();
        return client;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        if (props == null) {
            props = Collections.emptyMap();
        }
        if (!"true".equals(props.get("wildfly.sasl.mechanism-query-all")) && "true".equals(props.get("javax.security.sasl.server.authentication"))) {
            return new String[]{"9798-M-RSA-SHA1-ENC", "9798-M-DSA-SHA1", "9798-M-ECDSA-SHA1"};
        }
        return new String[]{"9798-U-RSA-SHA1-ENC", "9798-M-RSA-SHA1-ENC", "9798-U-DSA-SHA1", "9798-M-DSA-SHA1", "9798-U-ECDSA-SHA1", "9798-M-ECDSA-SHA1"};
    }
}

