/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util.sso;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpScopeNotification;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.util.sso.DefaultSingleSignOnSessionFactory;
import org.wildfly.security.http.util.sso.ElytronMessages;
import org.wildfly.security.http.util.sso.SingleSignOn;
import org.wildfly.security.http.util.sso.SingleSignOnSession;
import org.wildfly.security.http.util.sso.SingleSignOnSessionContext;

public class DefaultSingleSignOnSession
implements SingleSignOnSession {
    private static final String LOGOUT_REQUEST_PARAMETER = "ely_logout_message";
    private static final String SESSION_INVALIDATING_ATTRIBUTE = DefaultSingleSignOnSessionFactory.class.getName() + ".INVALIDATING";
    private static final Boolean SINGLE_SIGN_ON_KEY = Boolean.TRUE;
    private final HttpServerRequest request;
    private final ConcurrentMap<Boolean, SingleSignOn> map = new ConcurrentHashMap<Boolean, SingleSignOn>(1);
    private final SingleSignOnSessionContext context;
    private final Function<SecurityIdentity, SingleSignOn> ssoFactory;

    public DefaultSingleSignOnSession(SingleSignOnSessionContext context, HttpServerRequest request, String mechanismName, boolean programmatic) {
        this.context = (SingleSignOnSessionContext)Assert.checkNotNullParam((String)"context", (Object)context);
        this.request = (HttpServerRequest)Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
        this.ssoFactory = identity -> context.getSingleSignOnManager().create(mechanismName, programmatic, (SecurityIdentity)identity);
    }

    public DefaultSingleSignOnSession(SingleSignOnSessionContext context, HttpServerRequest request, SingleSignOn sso) {
        this.context = (SingleSignOnSessionContext)Assert.checkNotNullParam((String)"context", (Object)context);
        this.map.put(SINGLE_SIGN_ON_KEY, sso);
        this.request = (HttpServerRequest)Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"sso", (Object)sso);
        this.ssoFactory = identity -> sso;
    }

    @Override
    public String getId() {
        SingleSignOn sso = (SingleSignOn)this.map.get(SINGLE_SIGN_ON_KEY);
        return sso != null ? sso.getId() : null;
    }

    @Override
    public CachedIdentity get() {
        SingleSignOn sso = (SingleSignOn)this.map.get(SINGLE_SIGN_ON_KEY);
        return sso != null ? DefaultSingleSignOnSession.getCachedIdentity(sso) : null;
    }

    @Override
    public void put(SecurityIdentity identity) {
        SingleSignOn sso = this.map.computeIfAbsent(SINGLE_SIGN_ON_KEY, key -> this.ssoFactory.apply(identity));
        sso.setIdentity(identity);
        HttpScope scope = this.request.getScope(Scope.SESSION);
        if (!scope.exists()) {
            scope.create();
        }
        URI uri = this.request.getRequestURI();
        String sessionId = scope.getID();
        String applicationId = this.request.getScope(Scope.APPLICATION).getID();
        if (sso.addParticipant(applicationId, sessionId, uri)) {
            String id = sso.getId();
            ElytronMessages.log.debugf("Updating local sessions for SSO [%s]. New local session [%s]. Local sessions: [%s]", (Object)id, (Object)sessionId, (Object)sso.getParticipants());
            scope.registerForNotification(notification -> {
                HttpScope sessionScope = notification.getScope(Scope.SESSION);
                Map<String, Map.Entry<Object, Object>> logoutTargets = Collections.emptyMap();
                try (SingleSignOn target = this.context.getSingleSignOnManager().find(id);){
                    if (target != null) {
                        Map.Entry<String, URI> localParticipant = target.removeParticipant(applicationId);
                        if (localParticipant != null) {
                            ElytronMessages.log.debugf("Removed local session [%s] from SSO [%s]", (Object)localParticipant.getKey(), (Object)target.getId());
                        }
                        if (sessionScope.getAttachment(SESSION_INVALIDATING_ATTRIBUTE) == null) {
                            Map<String, Map.Entry<String, URI>> participants = target.getParticipants();
                            if (participants.isEmpty()) {
                                ElytronMessages.log.debugf("Destroying SSO [%s]. SSO is not associated with participants", (Object)target.getId());
                                target.invalidate();
                            } else if (notification.isOfType(HttpScopeNotification.SessionNotificationType.INVALIDATED)) {
                                logoutTargets = participants;
                            }
                        }
                    }
                }
                if (!logoutTargets.isEmpty()) {
                    logoutTargets.forEach((participantId, participant) -> {
                        String remoteSessionId = (String)participant.getKey();
                        URI remoteURI = (URI)participant.getValue();
                        try {
                            URL participantUrl = remoteURI.toURL();
                            HttpURLConnection connection = (HttpURLConnection)participantUrl.openConnection();
                            this.context.configureLogoutConnection(connection);
                            connection.setRequestMethod("POST");
                            connection.setDoOutput(true);
                            connection.setAllowUserInteraction(false);
                            connection.setConnectTimeout(10000);
                            connection.setReadTimeout(10000);
                            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            StringBuilder parameterBuilder = new StringBuilder();
                            parameterBuilder.append(LOGOUT_REQUEST_PARAMETER).append("=").append(this.context.createLogoutParameter(remoteSessionId));
                            connection.setRequestProperty("Content-Length", Integer.toString(parameterBuilder.length()));
                            try (OutputStream outputStream = connection.getOutputStream();
                                 DataOutputStream wr = new DataOutputStream(outputStream);){
                                wr.writeBytes(parameterBuilder.toString());
                            }
                            connection.getInputStream().close();
                        }
                        catch (Exception cause) {
                            ElytronMessages.log.warnHttpMechSsoFailedLogoutParticipant(remoteURI.toString(), cause);
                        }
                    });
                    target = this.context.getSingleSignOnManager().find(id);
                    try {
                        if (target != null) {
                            if (!target.getParticipants().isEmpty()) {
                                ElytronMessages.log.debugf("Destroying SSO [%s]. Participant list not empty.", (Object)target.getId());
                            } else {
                                ElytronMessages.log.debugf("Destroying SSO [%s]. SSO is no longer associated with any participants", (Object)target.getId());
                            }
                            target.invalidate();
                        }
                    }
                    finally {
                        if (target != null) {
                            target.close();
                        }
                    }
                }
            });
        }
    }

    @Override
    public CachedIdentity remove() {
        SingleSignOn sso = (SingleSignOn)this.map.get(SINGLE_SIGN_ON_KEY);
        if (sso == null) {
            return null;
        }
        sso.invalidate();
        HttpScope scope = this.request.getScope(Scope.SESSION);
        if (scope.exists()) {
            this.invalidateLocalSession(scope);
        }
        return DefaultSingleSignOnSession.getCachedIdentity(sso);
    }

    @Override
    public boolean logout() {
        String logoutMessage = this.request.getFirstParameterValue(LOGOUT_REQUEST_PARAMETER);
        if (logoutMessage == null) {
            return false;
        }
        try {
            String localSessionId = this.context.verifyLogoutParameter(logoutMessage);
            HttpScope scope = this.request.getScope(Scope.SESSION, localSessionId);
            if (!scope.exists()) {
                return false;
            }
            ElytronMessages.log.debugf("Invalidating local session [%s] from SSO [%s]", (Object)localSessionId, (Object)this.getId());
            this.invalidateLocalSession(scope);
        }
        catch (Exception e) {
            ElytronMessages.log.errorHttpMechSsoFailedInvalidateLocalSession(e);
        }
        this.request.authenticationInProgress(response -> response.setStatusCode(200));
        return true;
    }

    @Override
    public void close() {
        Optional.ofNullable((SingleSignOn)this.map.remove(SINGLE_SIGN_ON_KEY)).ifPresent(SingleSignOn::close);
    }

    void invalidateLocalSession(HttpScope scope) {
        scope.setAttachment(SESSION_INVALIDATING_ATTRIBUTE, true);
        scope.invalidate();
        ElytronMessages.log.debugf("Local session [%s] invalidated for SSO [%s]", (Object)scope.getID(), (Object)this.getId());
    }

    private static CachedIdentity getCachedIdentity(SingleSignOn sso) {
        String mechanism = sso.getMechanism();
        boolean programmatic = sso.isProgrammatic();
        SecurityIdentity identity = sso.getIdentity();
        return identity != null ? new CachedIdentity(mechanism, programmatic, identity) : new CachedIdentity(mechanism, programmatic, new NamePrincipal(sso.getName()));
    }
}

