/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.ElytronXmlParser;
import org.wildfly.security.auth.client._private.ElytronMessages;

public class WildFlyElytronClientDefaultSSLContextSpi
extends SSLContextSpi {
    private SSLContext configuredDefaultClientSSLContext;

    public WildFlyElytronClientDefaultSSLContextSpi() throws GeneralSecurityException {
        this(AuthenticationContext.captureCurrent());
    }

    public WildFlyElytronClientDefaultSSLContextSpi(String configPath) throws GeneralSecurityException, ConfigXMLParseException {
        this(ElytronXmlParser.parseAuthenticationClientConfiguration(WildFlyElytronClientDefaultSSLContextSpi.configPathUrlToUri(configPath)).create());
    }

    public WildFlyElytronClientDefaultSSLContextSpi(AuthenticationContext authenticationContext) throws GeneralSecurityException {
        Assert.checkNotNullParam((String)"authenticationContext", (Object)authenticationContext);
        AuthenticationContextConfigurationClient AUTH_CONTEXT_CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient::new);
        this.configuredDefaultClientSSLContext = AUTH_CONTEXT_CLIENT.getSSLContext(authenticationContext);
    }

    @Override
    protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) {
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return this.configuredDefaultClientSSLContext.getSocketFactory();
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return this.configuredDefaultClientSSLContext.getServerSocketFactory();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        return this.configuredDefaultClientSSLContext.createSSLEngine();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String s, int i) {
        return this.configuredDefaultClientSSLContext.createSSLEngine(s, i);
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.configuredDefaultClientSSLContext.getServerSessionContext();
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.configuredDefaultClientSSLContext.getClientSessionContext();
    }

    static URI configPathUrlToUri(String wildFlyConfig) {
        if (wildFlyConfig == null || wildFlyConfig.isEmpty()) {
            throw ElytronMessages.log.clientConfigurationFileNotValid();
        }
        if (File.separator.equals("\\") && wildFlyConfig.contains("\\")) {
            File f = new File(wildFlyConfig);
            return f.toPath().toUri();
        }
        try {
            URI uri = new URI(wildFlyConfig);
            if (!uri.isAbsolute()) {
                if (uri.getPath().charAt(0) != File.separatorChar && uri.getPath().charAt(0) != '/') {
                    String userDir = System.getProperty("user.dir").replace(File.separatorChar, '/');
                    return Paths.get(userDir, uri.getPath()).toUri();
                }
                return Paths.get(uri.getPath(), new String[0]).toUri();
            }
            return uri;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

