/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server._private.ElytronMessages;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.key.KeyUtil;

public interface RealmIdentity {
    public static final RealmIdentity ANONYMOUS = new RealmIdentity(){

        @Override
        public Principal getRealmIdentityPrincipal() {
            return AnonymousPrincipal.getInstance();
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }
    };
    public static final RealmIdentity NON_EXISTENT = new RealmIdentity(){

        @Override
        public Principal getRealmIdentityPrincipal() {
            return null;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return false;
        }

        public String toString() {
            return "NON_EXISTENT";
        }
    };

    public Principal getRealmIdentityPrincipal();

    default public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        return this.getCredentialAcquireSupport(credentialType, algorithmName, null);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> var1, String var2, AlgorithmParameterSpec var3) throws RealmUnavailableException;

    public <C extends Credential> C getCredential(Class<C> var1) throws RealmUnavailableException;

    default public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
        if (algorithmName != null) {
            C credential = this.getCredential(credentialType);
            return credential instanceof AlgorithmCredential && algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm()) ? (C)credential : null;
        }
        return this.getCredential(credentialType);
    }

    default public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType, algorithmName);
        if (parameterSpec != null) {
            if (!(credential instanceof AlgorithmCredential)) {
                return null;
            }
            return (C)(KeyUtil.parametersEqual(parameterSpec, ((AlgorithmCredential)credential).getParameters()) ? credential : null);
        }
        return credential;
    }

    default public <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType);
        return credential == null ? null : (R)credential.castAndApply(credentialType, function);
    }

    default public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType, algorithmName);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, function);
    }

    default public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType, algorithmName, parameterSpec);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, parameterSpec, function);
    }

    default public void updateCredential(Credential credential) throws RealmUnavailableException {
        throw ElytronMessages.log.credentialUpdateNotSupportedByRealm();
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> var1, String var2) throws RealmUnavailableException;

    public boolean verifyEvidence(Evidence var1) throws RealmUnavailableException;

    public boolean exists() throws RealmUnavailableException;

    default public void dispose() {
    }

    default public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
        if (this.exists()) {
            return AuthorizationIdentity.EMPTY;
        }
        throw ElytronMessages.log.userDoesNotExist();
    }

    default public Attributes getAttributes() throws RealmUnavailableException {
        return null;
    }
}

