/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.client.ClientRequest;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.httpclient.naming.ClassLoaderUtils;
import org.wildfly.httpclient.naming.ClientHandlers;
import org.wildfly.httpclient.naming.Constants;
import org.wildfly.httpclient.naming.HttpNamingEjbObjectResolverHelper;
import org.wildfly.httpclient.naming.HttpNamingProvider;
import org.wildfly.httpclient.naming.HttpRemoteContext;
import org.wildfly.httpclient.naming.RequestBuilder;
import org.wildfly.httpclient.naming.RequestType;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.ExhaustedDestinationsException;
import org.wildfly.naming.client.NamingOperation;
import org.wildfly.naming.client.ProviderEnvironment;
import org.wildfly.naming.client.RetryContext;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;

public class HttpRootContext
extends AbstractContext {
    private static final int MAX_NOT_FOUND_RETRY = Integer.getInteger("org.wildfly.httpclient.naming.max-retries", 8);
    private static final AuthenticationContextConfigurationClient CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final HttpNamingProvider httpNamingProvider;
    private final String scheme;
    private static final HttpNamingEjbObjectResolverHelper helper;

    protected HttpRootContext(FastHashtable<String, Object> environment, HttpNamingProvider httpNamingProvider, String scheme) {
        super(environment);
        this.httpNamingProvider = httpNamingProvider;
        this.scheme = scheme;
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        super.bind(name, obj);
    }

    @Override
    protected Object lookupNative(Name name) throws NamingException {
        return this.processInvocation(RequestType.LOOKUP, name);
    }

    @Override
    protected Object lookupLinkNative(Name name) throws NamingException {
        return this.processInvocation(RequestType.LOOKUP_LINK, name);
    }

    @Override
    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        Collection result = (Collection)this.processInvocation(RequestType.LIST, name);
        return CloseableNamingEnumeration.fromIterable(result);
    }

    @Override
    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        Collection result = (Collection)this.processInvocation(RequestType.LIST_BINDINGS, name);
        return CloseableNamingEnumeration.fromIterable(result);
    }

    @Override
    protected void bindNative(Name name, Object obj) throws NamingException {
        this.processInvocation(RequestType.BIND, name, null, obj);
    }

    @Override
    protected void rebindNative(Name name, Object obj) throws NamingException {
        this.processInvocation(RequestType.REBIND, name, null, obj);
    }

    @Override
    protected void unbindNative(Name name) throws NamingException {
        this.processInvocation(RequestType.UNBIND, name, null, null);
    }

    @Override
    protected void renameNative(Name oldName, Name newName) throws NamingException {
        this.processInvocation(RequestType.RENAME, oldName, newName, null);
    }

    @Override
    protected void destroySubcontextNative(Name name) throws NamingException {
        this.processInvocation(RequestType.DESTROY_SUBCONTEXT, name, null, null);
    }

    @Override
    protected Context createSubcontextNative(Name name) throws NamingException {
        this.processInvocation(RequestType.CREATE_SUBCONTEXT, name);
        return new HttpRemoteContext(this, name.toString());
    }

    private static ObjectResolver getObjectResolver(URI uri) {
        return helper != null ? helper.getObjectResolver(uri) : null;
    }

    private <T, R> R performWithRetry(NamingOperation<T, R> function, ProviderEnvironment environment, RetryContext context, Name name, T param) throws NamingException {
        if (context == null) {
            return function.apply(null, name, param);
        }
        int notFound = 0;
        while (true) {
            URI location;
            try {
                R result = function.apply(context, name, param);
                environment.dropFromBlocklist(context.currentDestination());
                return result;
            }
            catch (NameNotFoundException e) {
                if (notFound++ > MAX_NOT_FOUND_RETRY) {
                    Messages.log.tracef("Maximum name not found attempts exceeded,", new Object[0]);
                    throw e;
                }
                location = context.currentDestination();
                Messages.log.tracef("Provider (%s) did not have name \"%s\" (or a portion), retrying other nodes", (Object)location, (Object)name);
                context.addExplicitFailure(e);
                context.addTransientFail(location);
                continue;
            }
            catch (ExhaustedDestinationsException e) {
                throw e;
            }
            catch (CommunicationException t) {
                location = context.currentDestination();
                Messages.log.tracef((Throwable)t, "Communication error while contacting %s", (Object)location);
                this.updateBlocklist(environment, context, t);
                context.addFailure(HttpRootContext.injectDestination(t, location));
                continue;
            }
            catch (NamingException e) {
                environment.dropFromBlocklist(context.currentDestination());
                throw e;
            }
            catch (Throwable t) {
                location = context.currentDestination();
                Messages.log.tracef(t, "Unexpected throwable while contacting %s", (Object)location);
                context.addTransientFail(location);
                context.addFailure(HttpRootContext.injectDestination(t, location));
                continue;
            }
            break;
        }
    }

    private static Throwable injectDestination(Throwable t, URI destination) {
        StackTraceElement[] stackTrace = new StackTraceElement[5];
        System.arraycopy(t.getStackTrace(), 0, stackTrace, 1, 4);
        stackTrace[0] = new StackTraceElement("", "..use of destination...", destination.toString(), -1);
        t.setStackTrace(stackTrace);
        return t;
    }

    private void updateBlocklist(ProviderEnvironment environment, RetryContext context, Throwable t) {
        URI location = context.currentDestination();
        Messages.log.tracef(t, "Provider (%s) failed, blocklisting and retrying", (Object)location);
        environment.updateBlocklist(location);
    }

    private Object processInvocation(RequestType requestType, Name name) throws NamingException {
        return this.processInvocation(requestType, name, null, null, true);
    }

    private void processInvocation(RequestType requestType, Name name, Name newName, Object object) throws NamingException {
        this.processInvocation(requestType, name, newName, object, false);
    }

    private Object processInvocation(RequestType requestType, Name name, Name newName, Object object, boolean expectedValue) throws NamingException {
        ProviderEnvironment environment = this.httpNamingProvider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        return this.performWithRetry((contextOrNull, name1, param) -> {
            HttpNamingProvider.HttpPeerIdentity peerIdentity = (HttpNamingProvider.HttpPeerIdentity)this.httpNamingProvider.getPeerIdentityForNamingUsingRetry(contextOrNull);
            URI uri = peerIdentity.getUri();
            HttpTargetContext targetContext = WildflyHttpContext.getCurrent().getTargetContext(uri);
            RequestBuilder builder = new RequestBuilder().setRequestType(requestType).setName(name).setNewName(newName).setObject(object).setVersion(targetContext.getProtocolVersion());
            ClientRequest request = builder.createRequest(uri.getPath());
            if (expectedValue) {
                return this.performOperation(name1, uri, targetContext, request);
            }
            this.performOperation(uri, object, targetContext, request);
            return null;
        }, environment, context, name, object);
    }

    private Object performOperation(Name name, URI providerUri, HttpTargetContext targetContext, ClientRequest request) throws NamingException {
        SSLContext sslContext;
        ProviderEnvironment providerEnvironment = this.httpNamingProvider.getProviderEnvironment();
        AuthenticationContext context = providerEnvironment.getAuthenticationContextSupplier().get();
        AuthenticationContextConfigurationClient client = CLIENT;
        int defaultPort = providerUri.getScheme().equals("https") ? 443 : 80;
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(providerUri, context, defaultPort, "jndi", "jboss");
        try {
            sslContext = client.getSSLContext(providerUri, context, "jndi", "jboss");
        }
        catch (GeneralSecurityException e) {
            CommunicationException e2 = new CommunicationException(e.toString());
            e2.initCause(e);
            throw e2;
        }
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        ObjectResolver objectResolver = HttpRootContext.getObjectResolver(providerUri);
        HttpMarshallerFactory marshallerFactory = targetContext.getHttpMarshallerFactory(request);
        Unmarshaller unmarshaller = marshallerFactory.createUnmarshaller(objectResolver, result);
        if (unmarshaller != null) {
            targetContext.sendRequest(request, sslContext, authenticationConfiguration, null, ClientHandlers.optionalObjectHttpResultHandler(unmarshaller, result, this.httpNamingProvider, ClassLoaderUtils.getContextClassLoader()), result::completeExceptionally, Constants.VALUE, null, true);
        }
        try {
            Object ret = result.get();
            return ret == null ? new HttpRemoteContext(this, name.toString()) : ret;
        }
        catch (InterruptedException e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.initCause(e);
            throw namingException;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NamingException) {
                throw (NamingException)cause;
            }
            if (cause instanceof IOException) {
                CommunicationException communicationException = new CommunicationException(cause.getMessage());
                communicationException.initCause(cause);
                throw communicationException;
            }
            NamingException namingException = new NamingException();
            namingException.initCause(cause);
            throw namingException;
        }
    }

    private boolean canRetry(ProviderEnvironment environment) {
        return environment.getProviderUris().size() > 1;
    }

    private void performOperation(URI providerUri, Object object, HttpTargetContext targetContext, ClientRequest request) throws NamingException {
        SSLContext sslContext;
        ProviderEnvironment providerEnvironment = this.httpNamingProvider.getProviderEnvironment();
        AuthenticationContext context = providerEnvironment.getAuthenticationContextSupplier().get();
        AuthenticationContextConfigurationClient client = CLIENT;
        int defaultPort = providerUri.getScheme().equals("https") ? 443 : 80;
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(providerUri, context, defaultPort, "jndi", "jboss");
        try {
            sslContext = client.getSSLContext(providerUri, context, "jndi", "jboss");
        }
        catch (GeneralSecurityException e) {
            CommunicationException e2 = new CommunicationException(e.toString());
            e2.initCause(e);
            throw e2;
        }
        CompletableFuture result = new CompletableFuture();
        ObjectResolver objectResolver = HttpRootContext.getObjectResolver(providerUri);
        HttpMarshallerFactory marshallerFactory = targetContext.getHttpMarshallerFactory(request);
        Marshaller marshaller = marshallerFactory.createMarshaller(objectResolver, result);
        if (marshaller != null) {
            targetContext.sendRequest(request, sslContext, authenticationConfiguration, object != null ? ClientHandlers.objectHttpMarshaller(marshaller, object) : null, ClientHandlers.emptyHttpResultHandler(result, null), result::completeExceptionally, null, null);
        }
        try {
            result.get();
        }
        catch (InterruptedException e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.initCause(e);
            throw namingException;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NamingException) {
                throw (NamingException)cause;
            }
            NamingException namingException = new NamingException();
            namingException.initCause(cause);
            throw namingException;
        }
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        String scheme = this.scheme;
        return scheme == null || scheme.isEmpty() ? "" : scheme + ":";
    }

    static {
        HttpNamingEjbObjectResolverHelper h = null;
        ServiceLoader sl = AccessController.doPrivileged(() -> ServiceLoader.load(HttpNamingEjbObjectResolverHelper.class));
        Iterator it = sl.iterator();
        if (it.hasNext()) {
            h = (HttpNamingEjbObjectResolverHelper)it.next();
        }
        helper = h;
    }
}

