/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.util.UtilExternalizerProvider;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EnumSetExternalizer<E extends Enum<E>>
implements Externalizer<EnumSet<E>> {
    static final Field ENUM_SET_CLASS_FIELD = (Field)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            for (Field field : EnumSet.class.getDeclaredFields()) {
                if (field.getType() != Class.class) continue;
                field.setAccessible(true);
                return field;
            }
            throw new IllegalStateException();
        }
    });

    public void writeObject(ObjectOutput output, EnumSet<E> set) throws IOException {
        Class<?> enumClass = this.findEnumClass(set);
        output.writeObject(enumClass);
        ?[] enumValues = enumClass.getEnumConstants();
        BitSet values = new BitSet(enumValues.length);
        for (int i = 0; i < enumValues.length; ++i) {
            values.set(i, set.contains(enumValues[i]));
        }
        UtilExternalizerProvider.BIT_SET.writeObject(output, values);
    }

    public EnumSet<E> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Class enumClass = (Class)input.readObject();
        BitSet values = (BitSet)UtilExternalizerProvider.BIT_SET.cast(BitSet.class).readObject(input);
        EnumSet<Enum> set = EnumSet.noneOf(enumClass);
        T[] enumValues = enumClass.getEnumConstants();
        for (int i = 0; i < enumValues.length; ++i) {
            if (!values.get(i)) continue;
            set.add((Enum)enumValues[i]);
        }
        return set;
    }

    public Class<EnumSet<E>> getTargetClass() {
        return EnumSet.class;
    }

    private Class<?> findEnumClass(final EnumSet<E> set) {
        EnumSet<E> nonEmptySet = set.isEmpty() ? EnumSet.complementOf(set) : set;
        Iterator values = nonEmptySet.iterator();
        if (values.hasNext()) {
            return ((Enum)values.next()).getDeclaringClass();
        }
        return (Class)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return (Class)ENUM_SET_CLASS_FIELD.get(set);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

