/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.common.WildflyHttpContext;
import org.wildfly.httpclient.naming.HttpNamingClientMessages;
import org.wildfly.httpclient.naming.HttpNamingEjbObjectResolverHelper;
import org.wildfly.httpclient.naming.HttpNamingProvider;
import org.wildfly.httpclient.naming.HttpRemoteContext;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.ExhaustedDestinationsException;
import org.wildfly.naming.client.NamingOperation;
import org.wildfly.naming.client.ProviderEnvironment;
import org.wildfly.naming.client.RetryContext;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.xnio.IoUtils;

public class HttpRootContext
extends AbstractContext {
    private static final int MAX_NOT_FOUND_RETRY = Integer.getInteger("org.wildfly.httpclient.naming.max-retries", 8);
    private static final AuthenticationContextConfigurationClient CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private static final PrivilegedAction<ClassLoader> GET_TCCL_ACTION = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private final String ACCEPT_VALUE = "application/x-wf-jndi-jbmar-value;version=1,application/x-wf-jbmar-exception;version=1";
    private final ContentType VALUE_TYPE = new ContentType("application/x-wf-jndi-jbmar-value", 1);
    private final HttpNamingProvider httpNamingProvider;
    private final String scheme;
    private static final HttpNamingEjbObjectResolverHelper helper;

    protected HttpRootContext(FastHashtable<String, Object> environment, HttpNamingProvider httpNamingProvider, String scheme) {
        super(environment);
        this.httpNamingProvider = httpNamingProvider;
        this.scheme = scheme;
    }

    public void bind(String name, Object obj) throws NamingException {
        super.bind(name, obj);
    }

    protected Object lookupNative(Name name) throws NamingException {
        return this.processInvocation(name, Methods.POST, "naming/v1/lookup/");
    }

    protected Object lookupLinkNative(Name name) throws NamingException {
        return this.processInvocation(name, Methods.POST, "naming/v1/lookuplink/");
    }

    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        Collection result = (Collection)this.processInvocation(name, Methods.GET, "naming/v1/list/");
        return CloseableNamingEnumeration.fromIterable((Iterable)result);
    }

    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        Collection result = (Collection)this.processInvocation(name, Methods.GET, "naming/v1/list-bindings/");
        return CloseableNamingEnumeration.fromIterable((Iterable)result);
    }

    protected void bindNative(Name name, Object obj) throws NamingException {
        this.processInvocation(name, Methods.PUT, obj, "naming/v1/bind/", null);
    }

    protected void rebindNative(Name name, Object obj) throws NamingException {
        this.processInvocation(name, Methods.PATCH, obj, "naming/v1/rebind/", null);
    }

    protected void unbindNative(Name name) throws NamingException {
        this.processInvocation(name, Methods.DELETE, null, "naming/v1/unbind/", null);
    }

    protected void renameNative(Name oldName, Name newName) throws NamingException {
        this.processInvocation(oldName, Methods.PATCH, null, "naming/v1/rename/", newName);
    }

    protected void destroySubcontextNative(Name name) throws NamingException {
        this.processInvocation(name, Methods.DELETE, null, "naming/v1/dest-subctx/", null);
    }

    protected Context createSubcontextNative(Name name) throws NamingException {
        this.processInvocation(name, Methods.PUT, "naming/v1/create-subcontext/");
        return new HttpRemoteContext(this, name.toString());
    }

    private static MarshallingConfiguration createMarshallingConfig(URI uri) {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        if (helper != null) {
            marshallingConfiguration.setObjectResolver(helper.getObjectResolver(uri));
        }
        return marshallingConfiguration;
    }

    private <T, R> R performWithRetry(NamingOperation<T, R> function, ProviderEnvironment environment, RetryContext context, Name name, T param) throws NamingException {
        if (context == null) {
            return (R)function.apply(null, name, param);
        }
        int notFound = 0;
        while (true) {
            URI location;
            try {
                Object result = function.apply(context, name, param);
                environment.dropFromBlocklist(context.currentDestination());
                return (R)result;
            }
            catch (NameNotFoundException e) {
                if (notFound++ > MAX_NOT_FOUND_RETRY) {
                    Messages.log.tracef("Maximum name not found attempts exceeded,", new Object[0]);
                    throw e;
                }
                location = context.currentDestination();
                Messages.log.tracef("Provider (%s) did not have name \"%s\" (or a portion), retrying other nodes", (Object)location, (Object)name);
                context.addExplicitFailure((Throwable)e);
                context.addTransientFail(location);
                continue;
            }
            catch (ExhaustedDestinationsException e) {
                throw e;
            }
            catch (CommunicationException t) {
                location = context.currentDestination();
                Messages.log.tracef((Throwable)t, "Communication error while contacting %s", (Object)location);
                this.updateBlocklist(environment, context, t);
                context.addFailure(HttpRootContext.injectDestination(t, location));
                continue;
            }
            catch (NamingException e) {
                environment.dropFromBlocklist(context.currentDestination());
                throw e;
            }
            catch (Throwable t) {
                location = context.currentDestination();
                Messages.log.tracef(t, "Unexpected throwable while contacting %s", (Object)location);
                context.addTransientFail(location);
                context.addFailure(HttpRootContext.injectDestination(t, location));
                continue;
            }
            break;
        }
    }

    private static Throwable injectDestination(Throwable t, URI destination) {
        StackTraceElement[] stackTrace = new StackTraceElement[5];
        System.arraycopy(t.getStackTrace(), 0, stackTrace, 1, 4);
        stackTrace[0] = new StackTraceElement("", "..use of destination...", destination.toString(), -1);
        t.setStackTrace(stackTrace);
        return t;
    }

    private void updateBlocklist(ProviderEnvironment environment, RetryContext context, Throwable t) {
        URI location = context.currentDestination();
        Messages.log.tracef(t, "Provider (%s) failed, blocklisting and retrying", (Object)location);
        environment.updateBlocklist(location);
    }

    private Object processInvocation(Name name, HttpString method, String pathSegment) throws NamingException {
        ProviderEnvironment environment = this.httpNamingProvider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        return this.performWithRetry((contextOrNull, name1, param) -> {
            try {
                HttpNamingProvider.HttpPeerIdentity peerIdentity = (HttpNamingProvider.HttpPeerIdentity)this.httpNamingProvider.getPeerIdentityForNamingUsingRetry(contextOrNull);
                StringBuilder sb = new StringBuilder();
                String uriPath = peerIdentity.getUri().getPath();
                sb.append(uriPath);
                if (!uriPath.endsWith("/")) {
                    sb.append("/");
                }
                sb.append(pathSegment).append(URLEncoder.encode(name.toString(), StandardCharsets.UTF_8.name()));
                ClientRequest clientRequest = new ClientRequest().setPath(sb.toString()).setMethod(method);
                clientRequest.getRequestHeaders().put(Headers.ACCEPT, "application/x-wf-jndi-jbmar-value;version=1,application/x-wf-jbmar-exception;version=1");
                return this.performOperation(name1, peerIdentity.getUri(), clientRequest);
            }
            catch (UnsupportedEncodingException e) {
                NamingException namingException = new NamingException(e.getMessage());
                namingException.initCause(e);
                throw namingException;
            }
        }, environment, context, name, null);
    }

    private Object performOperation(Name name, URI providerUri, ClientRequest clientRequest) throws NamingException {
        SSLContext sslContext;
        CompletableFuture result = new CompletableFuture();
        HttpTargetContext targetContext = WildflyHttpContext.getCurrent().getTargetContext(providerUri);
        ProviderEnvironment providerEnvironment = this.httpNamingProvider.getProviderEnvironment();
        AuthenticationContext context = (AuthenticationContext)providerEnvironment.getAuthenticationContextSupplier().get();
        AuthenticationContextConfigurationClient client = CLIENT;
        int defaultPort = providerUri.getScheme().equals("https") ? 443 : 80;
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(providerUri, context, defaultPort, "jndi", "jboss");
        try {
            sslContext = client.getSSLContext(providerUri, context, "jndi", "jboss");
        }
        catch (GeneralSecurityException e) {
            CommunicationException e2 = new CommunicationException(e.toString());
            e2.initCause(e);
            throw e2;
        }
        ClassLoader tccl = HttpRootContext.getContextClassLoader();
        targetContext.sendRequest(clientRequest, sslContext, authenticationConfiguration, null, (input, response, closeable) -> {
            try {
                if (response.getResponseCode() == 204) {
                    result.complete(new HttpRemoteContext(this, name.toString()));
                    IoUtils.safeClose((Closeable)input);
                    return;
                }
                this.httpNamingProvider.performExceptionAction((a, b) -> {
                    Exception exception = null;
                    Object returned = null;
                    ClassLoader old = HttpRootContext.setContextClassLoader(tccl);
                    try {
                        MarshallingConfiguration marshallingConfiguration = HttpRootContext.createMarshallingConfig(providerUri);
                        Unmarshaller unmarshaller = targetContext.createUnmarshaller(marshallingConfiguration);
                        unmarshaller.start((ByteInput)new InputStreamByteInput(input));
                        returned = unmarshaller.readObject();
                        if (unmarshaller.read() != -1) {
                            exception = HttpNamingClientMessages.MESSAGES.unexpectedDataInResponse();
                        }
                        unmarshaller.finish();
                        if (response.getResponseCode() >= 400) {
                            exception = (Exception)returned;
                        }
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                    finally {
                        HttpRootContext.setContextClassLoader(old);
                    }
                    if (exception != null) {
                        result.completeExceptionally(exception);
                    } else {
                        result.complete(returned);
                    }
                    return null;
                }, null, null);
            }
            finally {
                IoUtils.safeClose((Closeable)closeable);
            }
        }, result::completeExceptionally, this.VALUE_TYPE, null, true);
        try {
            return result.get();
        }
        catch (InterruptedException e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.initCause(e);
            throw namingException;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NamingException) {
                throw (NamingException)cause;
            }
            if (cause instanceof IOException) {
                CommunicationException communicationException = new CommunicationException(cause.getMessage());
                communicationException.initCause(cause);
                throw communicationException;
            }
            NamingException namingException = new NamingException();
            namingException.initCause(cause);
            throw namingException;
        }
    }

    private void processInvocation(Name name, HttpString method, Object object, String pathSegment, Name newName) throws NamingException {
        ProviderEnvironment environment = this.httpNamingProvider.getProviderEnvironment();
        RetryContext context = this.canRetry(environment) ? new RetryContext() : null;
        this.performWithRetry((contextOrNull, name1, param) -> {
            HttpNamingProvider.HttpPeerIdentity peerIdentity = (HttpNamingProvider.HttpPeerIdentity)this.httpNamingProvider.getPeerIdentityForNamingUsingRetry(contextOrNull);
            try {
                StringBuilder sb = new StringBuilder();
                String uriPath = peerIdentity.getUri().getPath();
                sb.append(uriPath);
                if (!uriPath.endsWith("/")) {
                    sb.append("/");
                }
                sb.append(pathSegment).append(URLEncoder.encode(name.toString(), StandardCharsets.UTF_8.name()));
                if (newName != null) {
                    sb.append("?new=");
                    sb.append(URLEncoder.encode(newName.toString(), StandardCharsets.UTF_8.name()));
                }
                ClientRequest clientRequest = new ClientRequest().setPath(sb.toString()).setMethod(method);
                clientRequest.getRequestHeaders().put(Headers.ACCEPT, "application/x-wf-jndi-jbmar-value;version=1,application/x-wf-jbmar-exception;version=1");
                if (object != null) {
                    clientRequest.getRequestHeaders().put(Headers.CONTENT_TYPE, this.VALUE_TYPE.toString());
                }
                this.performOperation(peerIdentity.getUri(), object, clientRequest);
                return null;
            }
            catch (UnsupportedEncodingException e) {
                NamingException namingException = new NamingException(e.getMessage());
                namingException.initCause(e);
                throw namingException;
            }
        }, environment, context, name, object);
    }

    private boolean canRetry(ProviderEnvironment environment) {
        return environment.getProviderUris().size() > 1;
    }

    private void performOperation(URI providerUri, Object object, ClientRequest clientRequest) throws NamingException {
        SSLContext sslContext;
        CompletableFuture result = new CompletableFuture();
        HttpTargetContext targetContext = WildflyHttpContext.getCurrent().getTargetContext(providerUri);
        ProviderEnvironment providerEnvironment = this.httpNamingProvider.getProviderEnvironment();
        AuthenticationContext context = (AuthenticationContext)providerEnvironment.getAuthenticationContextSupplier().get();
        AuthenticationContextConfigurationClient client = CLIENT;
        int defaultPort = providerUri.getScheme().equals("https") ? 443 : 80;
        AuthenticationConfiguration authenticationConfiguration = client.getAuthenticationConfiguration(providerUri, context, defaultPort, "jndi", "jboss");
        try {
            sslContext = client.getSSLContext(providerUri, context, "jndi", "jboss");
        }
        catch (GeneralSecurityException e) {
            CommunicationException e2 = new CommunicationException(e.toString());
            e2.initCause(e);
            throw e2;
        }
        targetContext.sendRequest(clientRequest, sslContext, authenticationConfiguration, output -> {
            if (object != null) {
                Marshaller marshaller = targetContext.createMarshaller(HttpRootContext.createMarshallingConfig(providerUri));
                marshaller.start(Marshalling.createByteOutput((OutputStream)output));
                marshaller.writeObject(object);
                marshaller.finish();
            }
            output.close();
        }, (input, response, closeable) -> {
            try {
                result.complete(null);
            }
            finally {
                IoUtils.safeClose((Closeable)closeable);
            }
        }, result::completeExceptionally, null, null);
        try {
            result.get();
        }
        catch (InterruptedException e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.initCause(e);
            throw namingException;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NamingException) {
                throw (NamingException)cause;
            }
            NamingException namingException = new NamingException();
            namingException.initCause(cause);
            throw namingException;
        }
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        String scheme = this.scheme;
        return scheme == null || scheme.isEmpty() ? "" : scheme + ":";
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GET_TCCL_ACTION);
    }

    static ClassLoader setContextClassLoader(final ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            return old;
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                return old;
            }
        });
    }

    static {
        HttpNamingEjbObjectResolverHelper h = null;
        ServiceLoader sl = AccessController.doPrivileged(() -> ServiceLoader.load(HttpNamingEjbObjectResolverHelper.class));
        Iterator it = sl.iterator();
        if (it.hasNext()) {
            h = (HttpNamingEjbObjectResolverHelper)it.next();
        }
        helper = h;
    }
}

