/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.junit.contract.info;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.ContractImpl;
import org.xenei.junit.contract.MethodUtils;

public class TestInfo {
    private Class<?> contractTest;
    private Class<?> contractClass;
    private Class<?>[] skipTests;
    private Method method;

    protected TestInfo(Class<?> testSuite, ContractImpl impl, Method m) {
        this.contractTest = testSuite;
        this.contractClass = impl.value();
        this.skipTests = impl.skip();
        this.method = m;
    }

    public TestInfo(Class<?> contractTest, Contract c) {
        this.contractTest = contractTest;
        this.contractClass = c.value();
        this.skipTests = new Class[0];
        this.method = MethodUtils.findAnnotatedSetter(contractTest, Contract.Inject.class);
        if (Modifier.isAbstract(contractTest.getModifiers())) {
            throw new IllegalStateException("Classes annotated with @Contract (" + contractTest + ") must not be abstract");
        }
        if (this.method == null) {
            throw new IllegalStateException("Classes annotated with @Contract (" + contractTest + ") must include a @Contract.Inject annotation on a non-abstract declared setter method");
        }
    }

    boolean hasInjection(Class<?> cls) {
        Constructor<?>[] constructors = this.contractTest.getConstructors();
        boolean retval = (!this.contractTest.isMemberClass() || Modifier.isStatic(this.contractTest.getModifiers())) && constructors.length == 1 && constructors[0].getParameterTypes().length == 0;
        return retval;
    }

    public Class<?>[] getSkipTests() {
        return this.skipTests;
    }

    public String getPackageName() {
        return this.contractClass.getPackage().getName();
    }

    public String getSimpleContractName() {
        return this.contractClass.getSimpleName();
    }

    public String getSimpleTestName() {
        return this.contractTest.getSimpleName();
    }

    public String getContractName() {
        return this.contractClass.getCanonicalName();
    }

    public String getTestName() {
        return this.contractTest.getCanonicalName();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.contractTest.getModifiers());
    }

    public Class<?> getTestClass() {
        return this.contractTest;
    }

    public Class<?> getContractClass() {
        return this.contractClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return String.format("[%s testing %s]", this.getSimpleTestName(), this.getSimpleContractName());
    }
}

