/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.FalseClassFilter;
import org.xenei.classpathutils.filter.TrueClassFilter;
import org.xenei.classpathutils.filter._AbstractConditionalFilter;

public class AndClassFilter
extends _AbstractConditionalFilter
implements Serializable {
    private static final long serialVersionUID = 7607072170374969854L;

    public AndClassFilter(Collection<ClassPathFilter> classFilters) {
        super(classFilters);
    }

    public AndClassFilter(ClassPathFilter ... classFilters) {
        super(classFilters);
    }

    @Override
    public String funcName() {
        return "And";
    }

    @Override
    public boolean accept(String className) {
        List<ClassPathFilter> filters = this.getFilters();
        if (filters.isEmpty()) {
            return false;
        }
        for (ClassPathFilter classFilter : filters) {
            if (classFilter.accept(className)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(URL url) {
        List<ClassPathFilter> filters = this.getFilters();
        if (filters.isEmpty()) {
            return false;
        }
        for (ClassPathFilter classFilter : filters) {
            if (classFilter.accept(url)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(Class<?> clazz) {
        List<ClassPathFilter> filters = this.getFilters();
        if (filters.isEmpty()) {
            return false;
        }
        for (ClassPathFilter classFilter : filters) {
            if (classFilter.accept(clazz)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ClassPathFilter optimize() {
        HashMap<String, ClassPathFilter> filters = new HashMap<String, ClassPathFilter>();
        boolean changed = false;
        for (ClassPathFilter cpf : this.getFilters()) {
            ClassPathFilter cpf2 = cpf.optimize();
            changed |= !cpf2.toString().equals(cpf.toString());
            if (cpf2 instanceof AndClassFilter) {
                changed = true;
                AndClassFilter acf = (AndClassFilter)cpf2;
                for (ClassPathFilter filter : acf.getFilters()) {
                    filters.put(filter.toString(), filter);
                }
                continue;
            }
            if (cpf2 == FalseClassFilter.FALSE) {
                return FalseClassFilter.FALSE;
            }
            if (cpf2 == TrueClassFilter.TRUE) {
                changed = true;
                continue;
            }
            filters.put(cpf2.toString(), cpf2);
        }
        if (filters.size() == 0) {
            return FalseClassFilter.FALSE;
        }
        if (filters.size() == 1) {
            return (ClassPathFilter)filters.values().iterator().next();
        }
        ArrayList<ClassPathFilter> filterOrder = new ArrayList<ClassPathFilter>(filters.values());
        filterOrder.sort(EXECUTION_ORDER);
        if (!changed) {
            Iterator iter1 = filters.values().iterator();
            Iterator iter2 = filterOrder.iterator();
            while (iter1.hasNext()) {
                if (((ClassPathFilter)iter1.next()).equals(iter2.next())) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            return new AndClassFilter(filterOrder);
        }
        return this;
    }
}

