/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter._AbstractBaseFilter;
import org.xenei.classpathutils.filter.types.ClassFilterType;

public class InterfaceClassFilter
extends _AbstractBaseFilter
implements ClassFilterType {
    private static final Log LOG = LogFactory.getLog(InterfaceClassFilter.class);
    public static final ClassPathFilter INTERFACE = new InterfaceClassFilter();

    private InterfaceClassFilter() {
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    @Override
    public String funcName() {
        return "InterfaceClass";
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return clazz.isInterface();
    }

    @Override
    public boolean accept(String className) {
        try {
            return this.accept(this.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public String[] args() {
        return NO_ARGS;
    }

    @Override
    public boolean accept(URL url) {
        return false;
    }

    @Override
    public ClassPathFilter optimize() {
        return this;
    }
}

