/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.FalseClassFilter;
import org.xenei.classpathutils.filter.TrueClassFilter;
import org.xenei.classpathutils.filter._AbstractBaseFilter;
import org.xenei.classpathutils.filter.types.CollectionFilterType;

public class NotClassFilter
extends _AbstractBaseFilter
implements CollectionFilterType {
    private static final Log LOG = LogFactory.getLog(NotClassFilter.class);
    private final ClassPathFilter filter;

    public NotClassFilter(ClassPathFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The filter must not be null");
        }
        this.filter = filter;
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    @Override
    public boolean accept(URL url) {
        return !this.filter.accept(url);
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return !this.filter.accept(clazz);
    }

    @Override
    public boolean accept(String className) {
        return !this.filter.accept(className);
    }

    @Override
    public String toString() {
        return ClassPathFilter.Util.toString(this);
    }

    @Override
    public String[] args() {
        return new String[]{this.filter.toString()};
    }

    @Override
    public ClassPathFilter optimize() {
        ClassPathFilter f = this.filter.optimize();
        if (f == FalseClassFilter.FALSE) {
            return TrueClassFilter.TRUE;
        }
        if (f == TrueClassFilter.TRUE) {
            return FalseClassFilter.FALSE;
        }
        if (f == this.filter) {
            return this;
        }
        return new NotClassFilter(f);
    }

    @Override
    public List<ClassPathFilter> getFilters() {
        return Arrays.asList(this.filter);
    }
}

