/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter;

import java.net.URL;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.ClassPathUtils;

public abstract class _AbstractBaseFilter
implements ClassPathFilter {
    protected static final String[] NO_ARGS = new String[0];

    protected abstract Log getLog();

    static String removeDotClass(String className) {
        return className.endsWith(".class") ? className.substring(0, className.length() - ".class".length()) : className;
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        String classNameStr = _AbstractBaseFilter.removeDotClass(className);
        try {
            return Class.forName(classNameStr, false, ClassPathUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            String err = String.format("Can not load %s: %s", className, e.toString());
            this.getLog().error((Object)err);
            ClassPathUtils.doLog(err);
            throw e;
        }
    }

    public String toString() {
        return ClassPathFilter.Util.toString(this);
    }

    public boolean equals(Object o) {
        if (o instanceof ClassPathFilter) {
            return ClassPathFilter.Util.equals(this, (ClassPathFilter)o);
        }
        return false;
    }

    public int hashCode() {
        return ClassPathFilter.Util.hashCode(this);
    }

    @Override
    public String funcName() {
        String func = this.getClass().getSimpleName();
        if (func.endsWith("ResourceFilter")) {
            return func.substring(0, func.length() - "ResourceFilter".length());
        }
        if (func.endsWith("ClassFilter")) {
            return func.substring(0, func.length() - "ClassFilter".length());
        }
        return func;
    }

    @Override
    public Collection<URL> filterURLs(Collection<URL> collection) {
        return ClassPathFilter.Util.filterURLs(collection, this);
    }

    @Override
    public Collection<String> filterNames(Collection<String> collection) {
        return ClassPathFilter.Util.filterNames(collection, this);
    }

    @Override
    public Collection<Class<?>> filterClasses(Collection<Class<?>> collection) {
        return ClassPathFilter.Util.filterClasses(collection, this);
    }
}

