/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.classpathutils.filter.parser;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xenei.classpathutils.Case;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.filter.AbstractClassFilter;
import org.xenei.classpathutils.filter.AndClassFilter;
import org.xenei.classpathutils.filter.AnnotationClassFilter;
import org.xenei.classpathutils.filter.FalseClassFilter;
import org.xenei.classpathutils.filter.HasAnnotationClassFilter;
import org.xenei.classpathutils.filter.InterfaceClassFilter;
import org.xenei.classpathutils.filter.NameClassFilter;
import org.xenei.classpathutils.filter.NotClassFilter;
import org.xenei.classpathutils.filter.OrClassFilter;
import org.xenei.classpathutils.filter.PrefixClassFilter;
import org.xenei.classpathutils.filter.RegexClassFilter;
import org.xenei.classpathutils.filter.SuffixClassFilter;
import org.xenei.classpathutils.filter.TrueClassFilter;
import org.xenei.classpathutils.filter.WildcardClassFilter;
import org.xenei.classpathutils.filter._AbstractStringFilter;
import org.xenei.classpathutils.filter.types.CollectionFilterType;

public class Parser {
    private Map<String, Class<? extends ClassPathFilter>> map = new HashMap<String, Class<? extends ClassPathFilter>>();

    public Parser() {
        this.map.put("abstractclass", AbstractClassFilter.class);
        this.map.put("and", AndClassFilter.class);
        this.map.put("annotationclass", AnnotationClassFilter.class);
        this.map.put("false", FalseClassFilter.class);
        this.map.put("hasannotation", HasAnnotationClassFilter.class);
        this.map.put("interfaceclass", InterfaceClassFilter.class);
        this.map.put("name", NameClassFilter.class);
        this.map.put("not", NotClassFilter.class);
        this.map.put("or", OrClassFilter.class);
        this.map.put("prefix", PrefixClassFilter.class);
        this.map.put("properties", PrefixClassFilter.class);
        this.map.put("regex", RegexClassFilter.class);
        this.map.put("suffix", SuffixClassFilter.class);
        this.map.put("true", TrueClassFilter.class);
        this.map.put("wildcard", WildcardClassFilter.class);
    }

    public ClassPathFilter parse(String filterStr) throws IllegalArgumentException {
        ParserInfo info = new ParserInfo(filterStr);
        String args = info.parseArgs();
        try {
            if (args.length() == 0) {
                try {
                    return (ClassPathFilter)ClassPathFilter.class.getDeclaredField(info.getStaticName()).get(null);
                }
                catch (NoSuchFieldException e) {
                    return (ClassPathFilter)info.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            if (NotClassFilter.class.isAssignableFrom(info.clazz)) {
                return new NotClassFilter(this.parse(args));
            }
            if (CollectionFilterType.class.isAssignableFrom(info.clazz)) {
                ArrayList<ClassPathFilter> consArgs = new ArrayList<ClassPathFilter>();
                int cnt = 0;
                int startPos = 0;
                boolean scanning = false;
                block17: for (int i = 0; i < args.length(); ++i) {
                    switch (args.charAt(i)) {
                        case '(': {
                            ++cnt;
                            continue block17;
                        }
                        case ')': {
                            if (--cnt != 0) continue block17;
                            consArgs.add(this.parse(args.substring(startPos, i + 1)));
                            scanning = true;
                            continue block17;
                        }
                        case ',': {
                            if (!scanning) continue block17;
                            startPos = i + 1;
                            continue block17;
                        }
                    }
                }
                return (ClassPathFilter)info.clazz.getConstructor(Collection.class).newInstance(consArgs);
            }
            if (_AbstractStringFilter.class.isAssignableFrom(info.clazz)) {
                return this.constructWithCase(info, args);
            }
            if (WildcardClassFilter.class.isAssignableFrom(info.clazz)) {
                return this.constructWithCase(info, args);
            }
            if (HasAnnotationClassFilter.class.isAssignableFrom(info.clazz)) {
                Class<?> cls;
                List<String> argStrLst = this.splitArgs(args);
                if (argStrLst.size() != 1) {
                    throw new IllegalArgumentException(String.format("Only one string me be provided for HasAnnotation: %s", args));
                }
                try {
                    cls = Thread.currentThread().getContextClassLoader().loadClass(args.trim());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(String.format("Error creating: %s: %s", info.name, e.getMessage()), e);
                }
                if (Annotation.class.isAssignableFrom(cls)) {
                    return new HasAnnotationClassFilter(cls);
                }
                throw new IllegalArgumentException(String.format("%s is not an Annotation", args));
            }
            if (RegexClassFilter.class.isAssignableFrom(info.clazz)) {
                List<String> argStrLst = this.splitArgs(args);
                if (argStrLst.size() == 0) {
                    throw new IllegalArgumentException(String.format("Not enough arguments for %s: %s", info.name, args));
                }
                Case caze = null;
                try {
                    caze = Case.forName(argStrLst.get(0));
                }
                catch (IllegalArgumentException expected) {
                    return new RegexClassFilter(argStrLst.get(0));
                }
                if (argStrLst.size() < 2) {
                    throw new IllegalArgumentException(String.format(" Not enough arguments for %s: %s", info.name, args));
                }
                return new RegexClassFilter(caze, argStrLst.get(1));
            }
            throw new IllegalArgumentException("Unrecognized filter: " + info.name);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(String.format("Unable to instantiate: %s: %s", info.name, e.getMessage()), e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(String.format("Security exception instantiating: %s: %s", info.name, e.getMessage()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("Error instantiating: %s: %s", info.name, e.getMessage()), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Error instantiating: %s: %s", info.name, e.getMessage()), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Can not find constructor for: %s: %s", info.name, e.getMessage()), e);
        }
    }

    private ClassPathFilter constructWithCase(ParserInfo info, String args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        List<String> argStrLst = this.splitArgs(args);
        if (argStrLst.size() == 0) {
            throw new IllegalArgumentException(String.format("Not enough arguments for %s: %s", info.name, args));
        }
        Case caze = null;
        try {
            caze = Case.forName(argStrLst.get(0));
        }
        catch (IllegalArgumentException expected) {
            return (ClassPathFilter)info.clazz.getConstructor(Collection.class).newInstance(argStrLst);
        }
        if (argStrLst.size() < 2) {
            throw new IllegalArgumentException(String.format(" Not enough arguments for %s: %s", info.name, args));
        }
        return (ClassPathFilter)info.clazz.getConstructor(Case.class, Collection.class).newInstance(caze, argStrLst.subList(1, argStrLst.size()));
    }

    private List<String> splitArgs(String args) {
        ArrayList<String> retval = new ArrayList<String>();
        for (String s : args.split(",")) {
            retval.add(s.trim());
        }
        return retval;
    }

    private final class ParserInfo {
        private String parserStr;
        private String name;
        private Class<? extends ClassPathFilter> clazz;

        ParserInfo(String parserStr) {
            this.parserStr = parserStr.trim();
            int pos = this.parserStr.indexOf(40);
            this.name = this.parserStr.substring(0, pos);
            this.clazz = (Class)Parser.this.map.get(this.name.toLowerCase());
            if (this.clazz == null) {
                throw new IllegalArgumentException(this.name + " is not a registered class filter");
            }
        }

        public String parseArgs() {
            int cnt = 1;
            block4: for (int i = this.name.length() + 1; i < this.parserStr.length(); ++i) {
                switch (this.parserStr.charAt(i)) {
                    case '(': {
                        ++cnt;
                        continue block4;
                    }
                    case ')': {
                        if (--cnt != 0) continue block4;
                        if (this.name.length() == i - 1) {
                            return "";
                        }
                        return this.parserStr.substring(this.name.length() + 1, i - 1);
                    }
                }
            }
            throw new IllegalStateException("Can not parse " + this.parserStr);
        }

        public String getStaticName() {
            StringBuilder sb = new StringBuilder();
            char[] nameChars = this.name.toCharArray();
            for (int i = 0; i < nameChars.length; ++i) {
                if (i > 0 && Character.isUpperCase(nameChars[i])) {
                    sb.append("_").append(nameChars[i]);
                    continue;
                }
                sb.append(Character.toUpperCase(nameChars[i]));
            }
            return sb.toString();
        }
    }
}

