/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.util.intern;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Preprocessor {
    private static final Map<String, Integer> PARAM_INDEX_MAP = new HashMap<String, Integer>();

    public static int getParameterIndex(String paramName) {
        String uppercase = paramName.toUpperCase(Locale.ENGLISH);
        Integer index = PARAM_INDEX_MAP.get(uppercase);
        if (index != null) {
            return index;
        }
        String number = paramName.replaceFirst("PARAM|ARG", "");
        if (number.matches("[0-9]+")) {
            return Integer.parseInt(number);
        }
        return -1;
    }

    public static String applyParams(String string, Map<String, Integer> paramNameIndexMap, Object[] args) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder applied = new StringBuilder();
        StringBuilder paramNameBuilder = new StringBuilder();
        boolean inVarname = false;
        for (int i = 0; i <= string.length() - 1; ++i) {
            char b;
            char a = string.charAt(i);
            char c = b = i < string.length() - 1 ? (char)string.charAt(i + 1) : (char)'X';
            if (a == '{' && b == '{') {
                applied.append('{');
                ++i;
                continue;
            }
            if (a == '}' && b == '}') {
                applied.append('}');
                ++i;
                continue;
            }
            if (a != '{') {
                applied.append(a);
                continue;
            }
            inVarname = true;
            while (i < string.length() - 2 && b != '}') {
                paramNameBuilder.append(b);
                b = string.charAt(++i + 1);
            }
            inVarname = b != '}';
            ++i;
            applied.append(Preprocessor.resolveParameter(paramNameBuilder.toString(), paramNameIndexMap, args));
            paramNameBuilder.delete(0, paramNameBuilder.length());
        }
        if (inVarname) {
            throw new IllegalArgumentException("Unmatched '{'");
        }
        return applied.toString();
    }

    private static String resolveParameter(String paramName, Map<String, Integer> paramNameIndexMap, Object[] args) {
        Integer index;
        if (paramNameIndexMap != null && (index = paramNameIndexMap.get(paramName.toUpperCase(Locale.ENGLISH))) != null) {
            return args[index].toString();
        }
        int index2 = Preprocessor.getParameterIndex(paramName);
        if (index2 >= 0) {
            return args[index2].toString();
        }
        throw new IllegalArgumentException("Can not find argument for parameter '" + paramName + "'");
    }

    static {
        for (int i = 0; i < 10; ++i) {
            PARAM_INDEX_MAP.put("ARG" + i, i);
            PARAM_INDEX_MAP.put("PARAM" + i, i);
            PARAM_INDEX_MAP.put(Integer.toString(i), i);
        }
    }
}

