/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlbeam.XBProjector;
import org.xmlbeam.exceptions.XBDocumentParsingException;
import org.xmlbeam.exceptions.XBIOException;
import org.xmlbeam.util.Base64;

public final class IOHelper {
    private static final String[] RESOURCE_PROTO_NAMES = new String[]{"resource://", "res://"};

    private static void addRequestProperties(Map<String, String> requestProperties, HttpURLConnection connection) {
        if (requestProperties != null) {
            for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
                connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public static Map<String, String> createBasicAuthenticationProperty(String username, String password) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            String base64Binary = Base64.printBase64Binary((username + ":" + password).getBytes("US-ASCII"));
            map.put("Authorization", "Basic " + base64Binary);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static InputStream httpGet(String httpurl, Map<String, String> ... requestProperties) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(httpurl).openConnection();
        for (Map<String, String> props : requestProperties) {
            IOHelper.addRequestProperties(props, connection);
        }
        return connection.getInputStream();
    }

    public static InputStream httpPost(String httpurl, String data, Map<String, String> ... requestProperties) throws IOException {
        byte[] bytes = data.getBytes("utf-8");
        URL url = new URL(httpurl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestProperty("Content-Length", Integer.toString(bytes.length));
        for (Map<String, String> props : requestProperties) {
            IOHelper.addRequestProperties(props, connection);
        }
        OutputStream outputStream = connection.getOutputStream();
        outputStream.write(bytes);
        outputStream.flush();
        return connection.getInputStream();
    }

    public static String inputStreamToString(InputStream inputStream, String ... optionalCharsetName) {
        Scanner scanner = optionalCharsetName == null || optionalCharsetName.length == 0 || optionalCharsetName[0] == null ? new Scanner(inputStream) : new Scanner(inputStream, optionalCharsetName[0]);
        String content = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
        return content;
    }

    public static byte[] dropUTF8BOM(byte[] source) {
        if (source == null) {
            return null;
        }
        if (source.length < 3) {
            return source;
        }
        if (source[0] == -17 && source[1] == -69 && source[2] == -65) {
            return Arrays.copyOfRange(source, 3, source.length);
        }
        return source;
    }

    public static Document loadDocument(XBProjector projector, InputStream is) {
        DocumentBuilder documentBuilder = projector.config().createDocumentBuilder();
        try {
            return documentBuilder.parse(is, "");
        }
        catch (SAXException e) {
            throw new XBDocumentParsingException(e);
        }
        catch (IOException e) {
            throw new XBIOException("Error during document loading", e);
        }
    }

    public static Document getDocumentFromURL(DocumentBuilder documentBuilder, String url, Map<String, String> requestProperties, Class<?> ... resourceAwareClasses) throws IOException {
        try {
            for (String resProto : RESOURCE_PROTO_NAMES) {
                if (!url.startsWith(resProto)) continue;
                String resourceName = url.substring(resProto.length());
                InputStream is = null;
                if (resourceAwareClasses != null) {
                    for (Class<?> clazz : resourceAwareClasses) {
                        if (clazz != null && (is = clazz.getResourceAsStream(resourceName)) != null) break;
                    }
                }
                if (is == null) {
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
                }
                if (is == null) {
                    throw new IOException("The resource '" + url + "' could not be found");
                }
                InputSource source = new InputSource(is);
                return documentBuilder.parse(source);
            }
            if (url.startsWith("http:") || url.startsWith("https:")) {
                return documentBuilder.parse(IOHelper.httpGet(url, requestProperties), url);
            }
            Document document = documentBuilder.parse(url);
            if (document == null) {
                throw new IOException("Document could not be created form uri " + url);
            }
            return document;
        }
        catch (SAXException e) {
            throw new XBDocumentParsingException(e);
        }
    }

    public static boolean isResourceProtocol(String url) {
        if (url == null) {
            return false;
        }
        for (String proto : RESOURCE_PROTO_NAMES) {
            if (!url.startsWith(proto)) continue;
            return true;
        }
        return false;
    }
}

