/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.util.intern;

import java.lang.reflect.Method;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.xmlbeam.types.StringRenderer;
import org.xmlbeam.util.intern.Preprocessor;
import org.xmlbeam.util.intern.ReflectionHelper;
import org.xmlbeam.util.intern.duplex.DuplexExpression;

public class MethodParamVariableResolver
implements XPathVariableResolver {
    private final XPathVariableResolver originalResolver;
    private Object[] args;
    private final Method method;
    private final DuplexExpression expression;
    private final StringRenderer stringRenderer;

    public MethodParamVariableResolver(Method method, Object[] args, DuplexExpression expression, StringRenderer stringRenderer, XPathVariableResolver originalResolver) {
        this.method = method;
        this.args = args;
        this.originalResolver = originalResolver;
        this.expression = expression;
        this.stringRenderer = stringRenderer;
    }

    @Override
    public Object resolveVariable(QName variableName) {
        if (variableName != null && variableName.getLocalPart() != null) {
            String uppercaseName = variableName.getLocalPart().toUpperCase(Locale.ENGLISH);
            Integer index = ReflectionHelper.getMethodParameterIndexes(this.method).get(uppercaseName);
            if (index != null) {
                return this.stringRenderer.render(this.args[index].getClass(), this.args[index], this.expression.getVariableFormatPattern(variableName.getLocalPart()));
            }
            int preprocessorIndex = Preprocessor.getParameterIndex(uppercaseName);
            if (preprocessorIndex >= 0) {
                return this.stringRenderer.render(this.args[preprocessorIndex].getClass(), this.args[preprocessorIndex], this.expression.getVariableFormatPattern(variableName.getLocalPart()));
            }
        }
        if (this.originalResolver == null) {
            return null;
        }
        return this.originalResolver.resolveVariable(variableName);
    }

    public void updateArgs(Object[] args) {
        this.args = args;
    }
}

