/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3.error;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

public class ElementsShouldSatisfy
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory elementsShouldSatisfy(Object actual, List<UnsatisfiedRequirement> elementsNotSatisfyingRestrictions, AssertionInfo info) {
        return new ElementsShouldSatisfy(actual, elementsNotSatisfyingRestrictions, info);
    }

    private ElementsShouldSatisfy(Object actual, List<UnsatisfiedRequirement> elementsNotSatisfyingRestrictions, AssertionInfo info) {
        super(String.format("%nExpecting all elements of:%n  %s%nto satisfy given requirements, but these elements did not:%n%n" + ElementsShouldSatisfy.describeErrors(elementsNotSatisfyingRestrictions, info), actual), new Object[0]);
    }

    private static String describeErrors(List<UnsatisfiedRequirement> elementsNotSatisfyingRequirements, AssertionInfo info) {
        return ElementsShouldSatisfy.escapePercent(elementsNotSatisfyingRequirements.stream().map(ur -> ur.describe(info)).collect(Collectors.joining(String.format("%n%n", new Object[0]))));
    }

    private static String escapePercent(String s) {
        return s.replace("%", "%%");
    }

    public static class UnsatisfiedRequirement {
        private final Object elementNotSatisfyingRequirements;
        private final String errorMessage;

        public UnsatisfiedRequirement(Object elementNotSatisfyingRequirements, String errorMessage) {
            this.elementNotSatisfyingRequirements = elementNotSatisfyingRequirements;
            this.errorMessage = errorMessage;
        }

        public String describe(AssertionInfo info) {
            return String.format("%s%nerror: %s", info.representation().toStringOf(this.elementNotSatisfyingRequirements), this.errorMessage);
        }

        public String toString() {
            return String.format("%s %s", this.elementNotSatisfyingRequirements, this.errorMessage);
        }
    }
}

