/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.error;

public final class Mark {
    private String name;
    private int line;
    private int column;
    private String buffer;
    private int pointer;

    public Mark(String name, int index, int line, int column, String buffer, int pointer) {
        this.name = name;
        this.line = line;
        this.column = column;
        this.buffer = buffer;
        this.pointer = pointer;
    }

    private boolean isLineBreak(char ch) {
        return "\u0000\r\n\u0085\u2028\u2029".indexOf(ch) != -1;
    }

    public String get_snippet(int indent, int max_length) {
        int i;
        if (this.buffer == null) {
            return null;
        }
        float half = max_length / 2 - 1;
        int start = this.pointer;
        String head = "";
        while (start > 0 && !this.isLineBreak(this.buffer.charAt(start - 1))) {
            if (!((float)(this.pointer - --start) > half)) continue;
            head = " ... ";
            start += 5;
            break;
        }
        String tail = "";
        int end = this.pointer;
        while (end < this.buffer.length() && !this.isLineBreak(this.buffer.charAt(end))) {
            if (!((float)(++end - this.pointer) > half)) continue;
            tail = " ... ";
            end -= 5;
            break;
        }
        String snippet = this.buffer.substring(start, end);
        StringBuffer result = new StringBuffer();
        for (i = 0; i < indent; ++i) {
            result.append(" ");
        }
        result.append(head);
        result.append(snippet);
        result.append(tail);
        result.append("\n");
        for (i = 0; i < indent + this.pointer - start + head.length(); ++i) {
            result.append(" ");
        }
        result.append("^");
        return result.toString();
    }

    public String get_snippet() {
        return this.get_snippet(4, 75);
    }

    public String toString() {
        String snippet = this.get_snippet();
        StringBuffer where = new StringBuffer(" in \"");
        where.append(this.name);
        where.append("\", line ");
        where.append(this.line);
        where.append(", column ");
        where.append(this.column);
        if (snippet != null) {
            where.append(":\n");
            where.append(snippet);
        }
        return where.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

