/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.parser.Production;
import org.yaml.snakeyaml.reader.Reader;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerImpl;
import org.yaml.snakeyaml.tokens.AliasToken;
import org.yaml.snakeyaml.tokens.AnchorToken;
import org.yaml.snakeyaml.tokens.BlockEndToken;
import org.yaml.snakeyaml.tokens.BlockEntryToken;
import org.yaml.snakeyaml.tokens.BlockMappingStartToken;
import org.yaml.snakeyaml.tokens.BlockSequenceStartToken;
import org.yaml.snakeyaml.tokens.DirectiveToken;
import org.yaml.snakeyaml.tokens.DocumentEndToken;
import org.yaml.snakeyaml.tokens.DocumentStartToken;
import org.yaml.snakeyaml.tokens.FlowEntryToken;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.StreamEndToken;
import org.yaml.snakeyaml.tokens.StreamStartToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserImpl
implements Parser {
    private static final Map<String, String> DEFAULT_TAGS = new HashMap<String, String>();
    private final Scanner scanner;
    private Event currentEvent;
    private List<Integer> yamlVersion;
    private Map<String, String> tagHandles;
    private final LinkedList<Production> states;
    private final LinkedList<Mark> marks;
    private Production state;

    public ParserImpl(Reader reader) {
        this.scanner = new ScannerImpl(reader);
        this.currentEvent = null;
        this.yamlVersion = null;
        this.tagHandles = new HashMap<String, String>();
        this.states = new LinkedList();
        this.marks = new LinkedList();
        this.state = new ParseStreamStart();
    }

    @Override
    public boolean checkEvent(List<Class<? extends Event>> choices) {
        this.peekEvent();
        if (this.currentEvent != null) {
            if (choices.size() == 0) {
                return true;
            }
            for (Class<? extends Event> class1 : choices) {
                if (!class1.isInstance(this.currentEvent)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkEvent(Class<? extends Event> cls) {
        ArrayList<Class<? extends Event>> list = new ArrayList<Class<? extends Event>>(1);
        list.add(cls);
        return this.checkEvent(list);
    }

    @Override
    public Event peekEvent() {
        if (this.currentEvent == null && this.state != null) {
            this.currentEvent = this.state.produce();
        }
        return this.currentEvent;
    }

    @Override
    public Event getEvent() {
        this.peekEvent();
        Event value = this.currentEvent;
        this.currentEvent = null;
        return value;
    }

    private List<Object> processDirectives() {
        this.yamlVersion = null;
        this.tagHandles = new HashMap<String, String>();
        while (this.scanner.checkToken(DirectiveToken.class)) {
            List<?> value;
            DirectiveToken token = (DirectiveToken)this.scanner.getToken();
            if (token.getName().equals("YAML")) {
                if (this.yamlVersion != null) {
                    throw new ParserException(null, null, "found duplicate YAML directive", token.getStartMark());
                }
                value = token.getValue();
                Integer major = (Integer)value.get(0);
                if (major != 1) {
                    throw new ParserException(null, null, "found incompatible YAML document (version 1.* is required)", token.getStartMark());
                }
                this.yamlVersion = token.getValue();
                continue;
            }
            if (!token.getName().equals("TAG")) continue;
            value = token.getValue();
            String handle = (String)value.get(0);
            String prefix = (String)value.get(1);
            if (this.tagHandles.containsKey(handle)) {
                throw new ParserException(null, null, "duplicate tag handle " + handle, token.getStartMark());
            }
            this.tagHandles.put(handle, prefix);
        }
        ArrayList<Object> value = new ArrayList<Object>(2);
        value.add(this.yamlVersion);
        if (!this.tagHandles.isEmpty()) {
            value.add(new HashMap<String, String>(this.tagHandles));
        } else {
            value.add(new HashMap());
        }
        for (String key : DEFAULT_TAGS.keySet()) {
            if (this.tagHandles.containsKey(key)) continue;
            this.tagHandles.put(key, DEFAULT_TAGS.get(key));
        }
        return value;
    }

    private Event parseFlowNode() {
        return this.parseNode(false, false);
    }

    private Event parseBlockNodeOrIndentlessSequence() {
        return this.parseNode(true, true);
    }

    private Event parseNode(boolean block, boolean indentlessSequence) {
        NodeEvent event;
        Mark startMark = null;
        Mark endMark = null;
        Mark tagMark = null;
        if (this.scanner.checkToken(AliasToken.class)) {
            AliasToken token = (AliasToken)this.scanner.getToken();
            event = new AliasEvent(token.getValue(), token.getStartMark(), token.getEndMark());
            this.state = this.states.removeLast();
        } else {
            boolean implicit;
            String anchor = null;
            String[] tagTokenTag = null;
            if (this.scanner.checkToken(AnchorToken.class)) {
                AnchorToken token = (AnchorToken)this.scanner.getToken();
                startMark = token.getStartMark();
                endMark = token.getEndMark();
                anchor = token.getValue();
                if (this.scanner.checkToken(TagToken.class)) {
                    TagToken tagToken = (TagToken)this.scanner.getToken();
                    tagMark = tagToken.getStartMark();
                    endMark = tagToken.getEndMark();
                    tagTokenTag = tagToken.getValue();
                }
            } else if (this.scanner.checkToken(TagToken.class)) {
                TagToken tagToken = (TagToken)this.scanner.getToken();
                tagMark = startMark = tagToken.getStartMark();
                endMark = tagToken.getEndMark();
                tagTokenTag = tagToken.getValue();
                if (this.scanner.checkToken(AnchorToken.class)) {
                    AnchorToken token = (AnchorToken)this.scanner.getToken();
                    endMark = token.getEndMark();
                    anchor = token.getValue();
                }
            }
            String tag = null;
            if (tagTokenTag != null) {
                void handle = tagTokenTag[0];
                void suffix = tagTokenTag[1];
                if (handle != null) {
                    if (!this.tagHandles.containsKey(handle)) {
                        throw new ParserException("while parsing a node", startMark, "found undefined tag handle " + (String)handle, tagMark);
                    }
                    tag = this.tagHandles.get(handle) + (String)suffix;
                } else {
                    tag = suffix;
                }
            }
            if (startMark == null) {
                endMark = startMark = this.scanner.peekToken().getStartMark();
            }
            event = null;
            boolean bl = implicit = tag == null || tag.equals("!");
            if (indentlessSequence && this.scanner.checkToken(BlockEntryToken.class)) {
                endMark = this.scanner.peekToken().getEndMark();
                event = new SequenceStartEvent(anchor, tag, implicit, startMark, endMark, Boolean.FALSE);
                this.state = new ParseIndentlessSequenceEntry();
            } else if (this.scanner.checkToken(ScalarToken.class)) {
                ScalarToken token = (ScalarToken)this.scanner.getToken();
                endMark = token.getEndMark();
                ImplicitTuple implicitValues = token.getPlain() && tag == null || "!".equals(tag) ? new ImplicitTuple(true, false) : (tag == null ? new ImplicitTuple(false, true) : new ImplicitTuple(false, false));
                event = new ScalarEvent(anchor, tag, implicitValues, token.getValue(), startMark, endMark, Character.valueOf(token.getStyle()));
                this.state = this.states.removeLast();
            } else if (this.scanner.checkToken(FlowSequenceStartToken.class)) {
                endMark = this.scanner.peekToken().getEndMark();
                event = new SequenceStartEvent(anchor, tag, implicit, startMark, endMark, Boolean.TRUE);
                this.state = new ParseFlowSequenceFirstEntry();
            } else if (this.scanner.checkToken(FlowMappingStartToken.class)) {
                endMark = this.scanner.peekToken().getEndMark();
                event = new MappingStartEvent(anchor, tag, implicit, startMark, endMark, Boolean.TRUE);
                this.state = new ParseFlowMappingFirstKey();
            } else if (block && this.scanner.checkToken(BlockSequenceStartToken.class)) {
                endMark = this.scanner.peekToken().getStartMark();
                event = new SequenceStartEvent(anchor, tag, implicit, startMark, endMark, Boolean.FALSE);
                this.state = new ParseBlockSequenceFirstEntry();
            } else if (block && this.scanner.checkToken(BlockMappingStartToken.class)) {
                endMark = this.scanner.peekToken().getStartMark();
                event = new MappingStartEvent(anchor, tag, implicit, startMark, endMark, Boolean.FALSE);
                this.state = new ParseBlockMappingFirstKey();
            } else if (anchor != null || tag != null) {
                event = new ScalarEvent(anchor, tag, new ImplicitTuple(implicit, false), "", startMark, endMark, Character.valueOf('\u0000'));
                this.state = this.states.removeLast();
            } else {
                String node = block ? "block" : "flow";
                Token token = this.scanner.peekToken();
                throw new ParserException("while parsing a " + node + " node", startMark, "expected the node content, but found " + token.getTokenId(), token.getStartMark());
            }
        }
        return event;
    }

    private Event processEmptyScalar(Mark mark) {
        return new ScalarEvent(null, null, new ImplicitTuple(true, false), "", mark, mark, Character.valueOf('\u0000'));
    }

    static {
        DEFAULT_TAGS.put("!", "!");
        DEFAULT_TAGS.put("!!", "tag:yaml.org,2002:");
    }

    private class ParseFlowMappingEmptyValue
    implements Production {
        private ParseFlowMappingEmptyValue() {
        }

        public Event produce() {
            ParserImpl.this.state = new ParseFlowMappingKey(false);
            return ParserImpl.this.processEmptyScalar(ParserImpl.this.scanner.peekToken().getStartMark());
        }
    }

    private class ParseFlowMappingValue
    implements Production {
        private ParseFlowMappingValue() {
        }

        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(ValueToken.class)) {
                Token token = ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> choices = new ArrayList<Class<? extends Token>>();
                choices.add(FlowEntryToken.class);
                choices.add(FlowMappingEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(choices)) {
                    ParserImpl.this.states.add(new ParseFlowMappingKey(false));
                    return ParserImpl.this.parseFlowNode();
                }
                ParserImpl.this.state = new ParseFlowMappingKey(false);
                return ParserImpl.this.processEmptyScalar(token.getEndMark());
            }
            ParserImpl.this.state = new ParseFlowMappingKey(false);
            Token token = ParserImpl.this.scanner.peekToken();
            return ParserImpl.this.processEmptyScalar(token.getStartMark());
        }
    }

    private class ParseFlowMappingKey
    implements Production {
        private boolean first = false;

        public ParseFlowMappingKey(boolean first) {
            this.first = first;
        }

        public Event produce() {
            if (!ParserImpl.this.scanner.checkToken(FlowMappingEndToken.class)) {
                if (!this.first) {
                    if (ParserImpl.this.scanner.checkToken(FlowEntryToken.class)) {
                        ParserImpl.this.scanner.getToken();
                    } else {
                        Token token = ParserImpl.this.scanner.peekToken();
                        throw new ParserException("while parsing a flow mapping", (Mark)ParserImpl.this.marks.getLast(), "expected ',' or '}', but got " + token.getTokenId(), token.getStartMark());
                    }
                }
                if (ParserImpl.this.scanner.checkToken(KeyToken.class)) {
                    Token token = ParserImpl.this.scanner.getToken();
                    ArrayList<Class<? extends Token>> choices = new ArrayList<Class<? extends Token>>();
                    choices.add(ValueToken.class);
                    choices.add(FlowEntryToken.class);
                    choices.add(FlowMappingEndToken.class);
                    if (!ParserImpl.this.scanner.checkToken(choices)) {
                        ParserImpl.this.states.add(new ParseFlowMappingValue());
                        return ParserImpl.this.parseFlowNode();
                    }
                    ParserImpl.this.state = new ParseFlowMappingValue();
                    return ParserImpl.this.processEmptyScalar(token.getEndMark());
                }
                if (!ParserImpl.this.scanner.checkToken(FlowMappingEndToken.class)) {
                    ParserImpl.this.states.add(new ParseFlowMappingEmptyValue());
                    return ParserImpl.this.parseFlowNode();
                }
            }
            Token token = ParserImpl.this.scanner.getToken();
            MappingEndEvent event = new MappingEndEvent(token.getStartMark(), token.getEndMark());
            ParserImpl.this.state = (Production)ParserImpl.this.states.removeLast();
            ParserImpl.this.marks.removeLast();
            return event;
        }
    }

    private class ParseFlowMappingFirstKey
    implements Production {
        private ParseFlowMappingFirstKey() {
        }

        public Event produce() {
            Token token = ParserImpl.this.scanner.getToken();
            ParserImpl.this.marks.add(token.getStartMark());
            return new ParseFlowMappingKey(true).produce();
        }
    }

    private class ParseFlowSequenceEntryMappingEnd
    implements Production {
        private ParseFlowSequenceEntryMappingEnd() {
        }

        public Event produce() {
            ParserImpl.this.state = new ParseFlowSequenceEntry(false);
            Token token = ParserImpl.this.scanner.peekToken();
            return new MappingEndEvent(token.getStartMark(), token.getEndMark());
        }
    }

    private class ParseFlowSequenceEntryMappingValue
    implements Production {
        private ParseFlowSequenceEntryMappingValue() {
        }

        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(ValueToken.class)) {
                Token token = ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> choices = new ArrayList<Class<? extends Token>>();
                choices.add(FlowEntryToken.class);
                choices.add(FlowSequenceEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(choices)) {
                    ParserImpl.this.states.add(new ParseFlowSequenceEntryMappingEnd());
                    return ParserImpl.this.parseFlowNode();
                }
                ParserImpl.this.state = new ParseFlowSequenceEntryMappingEnd();
                return ParserImpl.this.processEmptyScalar(token.getEndMark());
            }
            ParserImpl.this.state = new ParseFlowSequenceEntryMappingEnd();
            Token token = ParserImpl.this.scanner.peekToken();
            return ParserImpl.this.processEmptyScalar(token.getStartMark());
        }
    }

    private class ParseFlowSequenceEntryMappingKey
    implements Production {
        private ParseFlowSequenceEntryMappingKey() {
        }

        public Event produce() {
            Token token = ParserImpl.this.scanner.getToken();
            ArrayList<Class<? extends Token>> choices = new ArrayList<Class<? extends Token>>();
            choices.add(ValueToken.class);
            choices.add(FlowEntryToken.class);
            choices.add(FlowSequenceEndToken.class);
            if (!ParserImpl.this.scanner.checkToken(choices)) {
                ParserImpl.this.states.add(new ParseFlowSequenceEntryMappingValue());
                return ParserImpl.this.parseFlowNode();
            }
            ParserImpl.this.state = new ParseFlowSequenceEntryMappingValue();
            return ParserImpl.this.processEmptyScalar(token.getEndMark());
        }
    }

    private class ParseFlowSequenceEntry
    implements Production {
        private boolean first = false;

        public ParseFlowSequenceEntry(boolean first) {
            this.first = first;
        }

        public Event produce() {
            if (!ParserImpl.this.scanner.checkToken(FlowSequenceEndToken.class)) {
                if (!this.first) {
                    if (ParserImpl.this.scanner.checkToken(FlowEntryToken.class)) {
                        ParserImpl.this.scanner.getToken();
                    } else {
                        Token token = ParserImpl.this.scanner.peekToken();
                        throw new ParserException("while parsing a flow sequence", (Mark)ParserImpl.this.marks.getLast(), "expected ',' or ']', but got " + token.getTokenId(), token.getStartMark());
                    }
                }
                if (ParserImpl.this.scanner.checkToken(KeyToken.class)) {
                    Token token = ParserImpl.this.scanner.peekToken();
                    MappingStartEvent event = new MappingStartEvent(null, null, true, token.getStartMark(), token.getEndMark(), Boolean.TRUE);
                    ParserImpl.this.state = new ParseFlowSequenceEntryMappingKey();
                    return event;
                }
                if (!ParserImpl.this.scanner.checkToken(FlowSequenceEndToken.class)) {
                    ParserImpl.this.states.add(new ParseFlowSequenceEntry(false));
                    return ParserImpl.this.parseFlowNode();
                }
            }
            Token token = ParserImpl.this.scanner.getToken();
            SequenceEndEvent event = new SequenceEndEvent(token.getStartMark(), token.getEndMark());
            ParserImpl.this.state = (Production)ParserImpl.this.states.removeLast();
            ParserImpl.this.marks.removeLast();
            return event;
        }
    }

    private class ParseFlowSequenceFirstEntry
    implements Production {
        private ParseFlowSequenceFirstEntry() {
        }

        public Event produce() {
            Token token = ParserImpl.this.scanner.getToken();
            ParserImpl.this.marks.add(token.getStartMark());
            return new ParseFlowSequenceEntry(true).produce();
        }
    }

    private class ParseBlockMappingValue
    implements Production {
        private ParseBlockMappingValue() {
        }

        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(ValueToken.class)) {
                Token token = ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> choices = new ArrayList<Class<? extends Token>>();
                choices.add(KeyToken.class);
                choices.add(ValueToken.class);
                choices.add(BlockEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(choices)) {
                    ParserImpl.this.states.add(new ParseBlockMappingKey());
                    return ParserImpl.this.parseBlockNodeOrIndentlessSequence();
                }
                ParserImpl.this.state = new ParseBlockMappingKey();
                return ParserImpl.this.processEmptyScalar(token.getEndMark());
            }
            ParserImpl.this.state = new ParseBlockMappingKey();
            Token token = ParserImpl.this.scanner.peekToken();
            return ParserImpl.this.processEmptyScalar(token.getStartMark());
        }
    }

    private class ParseBlockMappingKey
    implements Production {
        private ParseBlockMappingKey() {
        }

        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(KeyToken.class)) {
                Token token = ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> choices = new ArrayList<Class<? extends Token>>();
                choices.add(KeyToken.class);
                choices.add(ValueToken.class);
                choices.add(BlockEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(choices)) {
                    ParserImpl.this.states.add(new ParseBlockMappingValue());
                    return ParserImpl.this.parseBlockNodeOrIndentlessSequence();
                }
                ParserImpl.this.state = new ParseBlockMappingValue();
                return ParserImpl.this.processEmptyScalar(token.getEndMark());
            }
            if (!ParserImpl.this.scanner.checkToken(BlockEndToken.class)) {
                Token token = ParserImpl.this.scanner.peekToken();
                throw new ParserException("while parsing a block mapping", (Mark)ParserImpl.this.marks.getLast(), "expected <block end>, but found " + token.getTokenId(), token.getStartMark());
            }
            Token token = ParserImpl.this.scanner.getToken();
            MappingEndEvent event = new MappingEndEvent(token.getStartMark(), token.getEndMark());
            ParserImpl.this.state = (Production)ParserImpl.this.states.removeLast();
            ParserImpl.this.marks.removeLast();
            return event;
        }
    }

    private class ParseBlockMappingFirstKey
    implements Production {
        private ParseBlockMappingFirstKey() {
        }

        public Event produce() {
            Token token = ParserImpl.this.scanner.getToken();
            ParserImpl.this.marks.add(token.getStartMark());
            return new ParseBlockMappingKey().produce();
        }
    }

    private class ParseIndentlessSequenceEntry
    implements Production {
        private ParseIndentlessSequenceEntry() {
        }

        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(BlockEntryToken.class)) {
                Token token = ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> choices = new ArrayList<Class<? extends Token>>();
                choices.add(BlockEntryToken.class);
                choices.add(KeyToken.class);
                choices.add(ValueToken.class);
                choices.add(BlockEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(choices)) {
                    ParserImpl.this.states.add(new ParseIndentlessSequenceEntry());
                    return new ParseBlockNode().produce();
                }
                ParserImpl.this.state = new ParseIndentlessSequenceEntry();
                return ParserImpl.this.processEmptyScalar(token.getEndMark());
            }
            Token token = ParserImpl.this.scanner.peekToken();
            SequenceEndEvent event = new SequenceEndEvent(token.getStartMark(), token.getEndMark());
            ParserImpl.this.state = (Production)ParserImpl.this.states.removeLast();
            return event;
        }
    }

    private class ParseBlockSequenceEntry
    implements Production {
        private ParseBlockSequenceEntry() {
        }

        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(BlockEntryToken.class)) {
                BlockEntryToken token = (BlockEntryToken)ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> choices = new ArrayList<Class<? extends Token>>();
                choices.add(BlockEntryToken.class);
                choices.add(BlockEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(choices)) {
                    ParserImpl.this.states.add(new ParseBlockSequenceEntry());
                    return new ParseBlockNode().produce();
                }
                ParserImpl.this.state = new ParseBlockSequenceEntry();
                return ParserImpl.this.processEmptyScalar(token.getEndMark());
            }
            if (!ParserImpl.this.scanner.checkToken(BlockEndToken.class)) {
                Token token = ParserImpl.this.scanner.peekToken();
                throw new ParserException("while parsing a block collection", (Mark)ParserImpl.this.marks.getLast(), "expected <block end>, but found " + token.getTokenId(), token.getStartMark());
            }
            Token token = ParserImpl.this.scanner.getToken();
            SequenceEndEvent event = new SequenceEndEvent(token.getStartMark(), token.getEndMark());
            ParserImpl.this.state = (Production)ParserImpl.this.states.removeLast();
            ParserImpl.this.marks.removeLast();
            return event;
        }
    }

    private class ParseBlockSequenceFirstEntry
    implements Production {
        private ParseBlockSequenceFirstEntry() {
        }

        public Event produce() {
            Token token = ParserImpl.this.scanner.getToken();
            ParserImpl.this.marks.add(token.getStartMark());
            return new ParseBlockSequenceEntry().produce();
        }
    }

    private class ParseBlockNode
    implements Production {
        private ParseBlockNode() {
        }

        public Event produce() {
            return ParserImpl.this.parseNode(true, false);
        }
    }

    private class ParseDocumentContent
    implements Production {
        private ParseDocumentContent() {
        }

        public Event produce() {
            ArrayList<Class<? extends Token>> choices = new ArrayList<Class<? extends Token>>();
            choices.add(DirectiveToken.class);
            choices.add(DocumentStartToken.class);
            choices.add(DocumentEndToken.class);
            choices.add(StreamEndToken.class);
            if (ParserImpl.this.scanner.checkToken(choices)) {
                Event event = ParserImpl.this.processEmptyScalar(ParserImpl.this.scanner.peekToken().getStartMark());
                ParserImpl.this.state = (Production)ParserImpl.this.states.removeLast();
                return event;
            }
            ParseBlockNode p = new ParseBlockNode();
            return p.produce();
        }
    }

    private class ParseDocumentEnd
    implements Production {
        private ParseDocumentEnd() {
        }

        public Event produce() {
            Mark startMark;
            Token token = ParserImpl.this.scanner.peekToken();
            Mark endMark = startMark = token.getStartMark();
            boolean explicit = false;
            if (ParserImpl.this.scanner.checkToken(DocumentEndToken.class)) {
                token = ParserImpl.this.scanner.getToken();
                endMark = token.getEndMark();
                explicit = true;
            }
            DocumentEndEvent event = new DocumentEndEvent(startMark, endMark, explicit);
            ParserImpl.this.state = new ParseDocumentStart();
            return event;
        }
    }

    private class ParseDocumentStart
    implements Production {
        private ParseDocumentStart() {
        }

        public Event produce() {
            Event event;
            while (ParserImpl.this.scanner.checkToken(DocumentEndToken.class)) {
                ParserImpl.this.scanner.getToken();
            }
            if (!ParserImpl.this.scanner.checkToken(StreamEndToken.class)) {
                Integer[] versionInteger;
                Token token = ParserImpl.this.scanner.peekToken();
                Mark startMark = token.getStartMark();
                List version_tags = ParserImpl.this.processDirectives();
                List version = (List)version_tags.get(0);
                Map tags = (Map)version_tags.get(1);
                if (!ParserImpl.this.scanner.checkToken(DocumentStartToken.class)) {
                    throw new ParserException(null, null, "expected '<document start>', but found " + ParserImpl.this.scanner.peekToken().getTokenId(), ParserImpl.this.scanner.peekToken().getStartMark());
                }
                token = ParserImpl.this.scanner.getToken();
                Mark endMark = token.getEndMark();
                if (version != null) {
                    versionInteger = new Integer[2];
                    versionInteger = version.toArray(versionInteger);
                } else {
                    versionInteger = null;
                }
                event = new DocumentStartEvent(startMark, endMark, true, versionInteger, tags);
                ParserImpl.this.states.add(new ParseDocumentEnd());
                ParserImpl.this.state = new ParseDocumentContent();
            } else {
                StreamEndToken token = (StreamEndToken)ParserImpl.this.scanner.getToken();
                event = new StreamEndEvent(token.getStartMark(), token.getEndMark());
                if (!ParserImpl.this.states.isEmpty()) {
                    throw new YAMLException("Unexpected end of stream. States left: " + ParserImpl.this.states);
                }
                if (!ParserImpl.this.marks.isEmpty()) {
                    throw new YAMLException("Unexpected end of stream. Marks left: " + ParserImpl.this.marks);
                }
                ParserImpl.this.state = null;
            }
            return event;
        }
    }

    private class ParseImplicitDocumentStart
    implements Production {
        private ParseImplicitDocumentStart() {
        }

        public Event produce() {
            ArrayList<Class<? extends Token>> choices = new ArrayList<Class<? extends Token>>();
            choices.add(DirectiveToken.class);
            choices.add(DocumentStartToken.class);
            choices.add(StreamEndToken.class);
            if (!ParserImpl.this.scanner.checkToken(choices)) {
                Mark startMark;
                ParserImpl.this.tagHandles = DEFAULT_TAGS;
                Token token = ParserImpl.this.scanner.peekToken();
                Mark endMark = startMark = token.getStartMark();
                DocumentStartEvent event = new DocumentStartEvent(startMark, endMark, false, null, null);
                ParserImpl.this.states.add(new ParseDocumentEnd());
                ParserImpl.this.state = new ParseBlockNode();
                return event;
            }
            ParseDocumentStart p = new ParseDocumentStart();
            return p.produce();
        }
    }

    private class ParseStreamStart
    implements Production {
        private ParseStreamStart() {
        }

        public Event produce() {
            StreamStartToken token = (StreamStartToken)ParserImpl.this.scanner.getToken();
            StreamStartEvent event = new StreamStartEvent(token.getStartMark(), token.getEndMark());
            ParserImpl.this.state = new ParseImplicitDocumentStart();
            return event;
        }
    }
}

