/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.zalando.logbook.BaseHttpRequest;

final class RequestURI {
    RequestURI() {
    }

    static String reconstruct(BaseHttpRequest request) {
        return RequestURI.reconstruct(request, EnumSet.allOf(Component.class));
    }

    static String reconstruct(BaseHttpRequest request, Component ... components) {
        return RequestURI.reconstruct(request, EnumSet.copyOf(Arrays.asList(components)));
    }

    private static String reconstruct(BaseHttpRequest request, Set<Component> components) {
        String scheme = request.getScheme();
        String host = request.getHost();
        Optional<Integer> port = request.getPort();
        String path = request.getPath();
        String query = request.getQuery();
        StringBuilder url = new StringBuilder();
        if (components.contains((Object)Component.SCHEME)) {
            url.append(scheme).append(":");
        }
        if (components.contains((Object)Component.AUTHORITY)) {
            url.append("//").append(host);
            port.ifPresent(p -> {
                if (RequestURI.isNotStandardPort(scheme, p)) {
                    url.append(':').append(p);
                }
            });
        } else if (components.contains((Object)Component.SCHEME)) {
            url.append("//");
        }
        if (components.contains((Object)Component.PATH)) {
            url.append(path);
        } else {
            url.append('/');
        }
        if (components.contains((Object)Component.QUERY) && !query.isEmpty()) {
            url.append('?').append(query);
        }
        return url.toString();
    }

    private static boolean isNotStandardPort(String scheme, int port) {
        return "http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443;
    }

    static enum Component {
        SCHEME,
        AUTHORITY,
        PATH,
        QUERY;

    }
}

