/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.zalando.logbook.HttpRequest;

final class RequestURI {
    private RequestURI() {
    }

    static String reconstruct(HttpRequest request) {
        StringBuilder url = new StringBuilder();
        RequestURI.reconstruct(request, url);
        return url.toString();
    }

    static void reconstruct(HttpRequest request, StringBuilder output) {
        RequestURI.reconstruct(request, EnumSet.allOf(Component.class), output);
    }

    static String reconstruct(HttpRequest request, Component ... components) {
        StringBuilder url = new StringBuilder();
        RequestURI.reconstruct(request, EnumSet.copyOf(Arrays.asList(components)), url);
        return url.toString();
    }

    static String reconstruct(HttpRequest request, Set<Component> components) {
        StringBuilder url = new StringBuilder();
        RequestURI.reconstruct(request, components, url);
        return url.toString();
    }

    private static void reconstruct(HttpRequest request, Set<Component> components, StringBuilder url) {
        String scheme = request.getScheme();
        String host = request.getHost();
        Optional<Integer> port = request.getPort();
        String path = request.getPath();
        String query = request.getQuery();
        if (components.contains((Object)Component.SCHEME)) {
            url.append(scheme).append(':');
        }
        if (components.contains((Object)Component.AUTHORITY)) {
            url.append("//").append(host);
            port.ifPresent(p -> {
                if (RequestURI.isNotStandardPort(scheme, p)) {
                    url.append(':').append(p);
                }
            });
        } else if (components.contains((Object)Component.SCHEME)) {
            url.append("//");
        }
        if (components.contains((Object)Component.PATH)) {
            url.append(path);
        } else {
            url.append('/');
        }
        if (components.contains((Object)Component.QUERY) && !query.isEmpty()) {
            url.append('?').append(query);
        }
    }

    private static boolean isNotStandardPort(String scheme, int port) {
        return "http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443;
    }

    static enum Component {
        SCHEME,
        AUTHORITY,
        PATH,
        QUERY;

    }
}

