/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import java.io.CharArrayWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.ContentType;
import org.zalando.logbook.json.DefaultJsonGeneratorWrapper;
import org.zalando.logbook.json.JsonGeneratorWrapper;
import org.zalando.logbook.json.StringReplaceJsonCompactor;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.json.JsonFactory;

public class JacksonJsonFieldBodyFilter
implements BodyFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonJsonFieldBodyFilter.class);
    private static final StringReplaceJsonCompactor fallbackCompactor = new StringReplaceJsonCompactor();
    private final String replacement;
    private final Set<String> fields;
    private final JsonFactory factory;
    private final JsonGeneratorWrapper jsonGeneratorWrapper;

    public JacksonJsonFieldBodyFilter(Collection<String> fieldNames, String replacement, JsonFactory factory, JsonGeneratorWrapper jsonGeneratorWrapper) {
        this.fields = new HashSet<String>(fieldNames);
        this.replacement = replacement;
        this.factory = factory;
        this.jsonGeneratorWrapper = jsonGeneratorWrapper;
    }

    public JacksonJsonFieldBodyFilter(Collection<String> fieldNames, String replacement, JsonFactory factory) {
        this(fieldNames, replacement, factory, new DefaultJsonGeneratorWrapper());
    }

    public JacksonJsonFieldBodyFilter(Collection<String> fieldNames, String replacement) {
        this(fieldNames, replacement, new JsonFactory());
    }

    public String filter(@Nullable String contentType, String body) {
        return ContentType.isJsonMediaType((String)contentType) ? this.filter(body) : body;
    }

    public String filter(String body) {
        CharArrayWriter writer = new CharArrayWriter(body.length() * 2);
        try {
            try (JsonParser parser = this.factory.createParser(ObjectReadContext.empty(), body);
                 JsonGenerator generator = this.factory.createGenerator(ObjectWriteContext.empty(), (Writer)writer);){
                JsonToken nextToken;
                while ((nextToken = parser.nextToken()) != null) {
                    this.jsonGeneratorWrapper.copyCurrentEvent(generator, parser);
                    if (nextToken != JsonToken.PROPERTY_NAME || !this.fields.contains(parser.currentName())) continue;
                    nextToken = parser.nextToken();
                    generator.writeString(this.replacement);
                    if (nextToken.isScalarValue()) continue;
                    parser.skipChildren();
                }
            }
            String string = writer.toString();
            writer.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.trace("Unable to filter body for fields {}, compacting result. `{}`", this.fields, (Object)e.getMessage());
                return fallbackCompactor.compact(body);
            }
        }
    }
}

