/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import java.io.IOException;
import org.apiguardian.api.API;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.Precorrelation;
import tools.jackson.core.JsonGenerator;

public interface JsonFieldWriter {
    public <M extends HttpMessage> void write(M var1, JsonGenerator var2) throws IOException;

    @API(status=API.Status.EXPERIMENTAL)
    default public void write(Precorrelation correlation, HttpRequest request, JsonGenerator generator) throws IOException {
        generator.writeName("origin");
        generator.writeString(JsonFieldWriter.getOrigin((HttpMessage)request));
        generator.writeName("type");
        generator.writeString("request");
        generator.writeName("correlation");
        generator.writeString(correlation.getId());
        generator.writeName("protocol");
        generator.writeString(request.getProtocolVersion());
        generator.writeName("remote");
        generator.writeString(request.getRemote());
        generator.writeName("method");
        generator.writeString(request.getMethod());
        generator.writeName("uri");
        generator.writeString(request.getRequestUri());
    }

    @API(status=API.Status.EXPERIMENTAL)
    default public void write(Correlation correlation, HttpResponse response, JsonGenerator generator) throws IOException {
        generator.writeName("origin");
        generator.writeString(JsonFieldWriter.getOrigin((HttpMessage)response));
        generator.writeName("type");
        generator.writeString("response");
        generator.writeName("correlation");
        generator.writeString(correlation.getId());
        generator.writeName("protocol");
        generator.writeString(response.getProtocolVersion());
        generator.writeName("duration");
        generator.writeNumber(correlation.getDuration().toMillis());
        generator.writeName("status");
        generator.writeNumber(response.getStatus());
    }

    public static String getOrigin(HttpMessage message) {
        return message.getOrigin() == Origin.LOCAL ? "local" : "remote";
    }
}

