/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.ContentType;
import org.zalando.logbook.json.LogbookJacksonJsonProvider;
import org.zalando.logbook.json.LogbookJacksonMappingProvider;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.BooleanNode;
import tools.jackson.databind.node.DoubleNode;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.StringNode;

@API(status=API.Status.EXPERIMENTAL)
public final class JsonPathBodyFilters {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonPathBodyFilters.class);

    private static JsonPathBodyFilter filter(Operation operation) {
        return new JsonPathBodyFilter(operation);
    }

    public static JsonPathBodyFilterBuilder jsonPath(String jsonPath) {
        return new JsonPathBodyFilterBuilder(JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]));
    }

    @Generated
    private JsonPathBodyFilters() {
    }

    private static class JsonPathBodyFilter
    implements BodyFilter {
        private static final ParseContext CONTEXT = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new LogbookJacksonJsonProvider()).mappingProvider((MappingProvider)new LogbookJacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).options(new Option[]{Option.ALWAYS_RETURN_LIST}).build());
        private final Operation operation;

        public String filter(@Nullable String contentType, String body) {
            if (body.isEmpty() || !ContentType.isJsonMediaType((String)contentType)) {
                return body;
            }
            try {
                DocumentContext original = CONTEXT.parse(body);
                return this.operation.filter(original).jsonString();
            }
            catch (Exception e) {
                log.trace("The body could not be filtered, the following exception {} has been thrown", e.getClass());
                return body;
            }
        }

        @Nullable
        public BodyFilter tryMerge(BodyFilter next) {
            if (next instanceof JsonPathBodyFilter) {
                JsonPathBodyFilter filter = (JsonPathBodyFilter)next;
                return new JsonPathBodyFilter(Operation.composite(this.operation, filter.operation));
            }
            return super.tryMerge(next);
        }

        @Generated
        public JsonPathBodyFilter(Operation operation) {
            this.operation = operation;
        }
    }

    @FunctionalInterface
    private static interface Operation {
        public DocumentContext filter(DocumentContext var1);

        public static Operation composite(Operation ... operations) {
            return Operation.composite(Arrays.asList(operations));
        }

        public static Operation composite(Collection<Operation> operations) {
            return new CompositeOperation(operations);
        }
    }

    public static final class JsonPathBodyFilterBuilder {
        private final JsonPath path;

        public BodyFilter delete() {
            return JsonPathBodyFilters.filter(context -> context.delete(this.path));
        }

        public BodyFilter replace(String replacement) {
            return this.replace((JsonNode)new StringNode(replacement));
        }

        public BodyFilter replace(Boolean replacement) {
            return this.replace((JsonNode)BooleanNode.valueOf((boolean)replacement));
        }

        public BodyFilter replace(Double replacement) {
            return this.replace((JsonNode)new DoubleNode(replacement.doubleValue()));
        }

        public BodyFilter replace(JsonNode replacement) {
            return JsonPathBodyFilters.filter(context -> context.set(this.path, (Object)replacement));
        }

        public BodyFilter replace(UnaryOperator<String> replacementFunction) {
            return JsonPathBodyFilters.filter(context -> context.map(this.path, (node, config) -> {
                Object unwrapped = context.configuration().jsonProvider().unwrap(node);
                return unwrapped == null ? NullNode.getInstance() : new StringNode((String)replacementFunction.apply(unwrapped.toString()));
            }));
        }

        public BodyFilter replace(Pattern pattern, String replacement) {
            return JsonPathBodyFilters.filter(context -> context.map(this.path, (node, config) -> {
                Object unwrapped = context.configuration().jsonProvider().unwrap(node);
                if (unwrapped == null) {
                    return NullNode.getInstance();
                }
                Matcher matcher = pattern.matcher(unwrapped.toString());
                if (matcher.find()) {
                    return new StringNode(matcher.replaceAll(replacement));
                }
                return unwrapped;
            }));
        }

        @Generated
        private JsonPathBodyFilterBuilder(JsonPath path) {
            this.path = path;
        }
    }

    private static final class CompositeOperation
    implements Operation {
        private final Collection<Operation> operations;

        @Override
        public DocumentContext filter(DocumentContext context) {
            DocumentContext result = context;
            ArrayList<String> filterExceptions = new ArrayList<String>();
            for (Operation operation : this.operations) {
                try {
                    result = operation.filter(result);
                }
                catch (Exception e) {
                    filterExceptions.add(String.format("Exception class: %s. Message: %s", e.getClass().getName(), e.getMessage()));
                }
            }
            if (!filterExceptions.isEmpty()) {
                log.trace("JsonPathBodyFilter filter operation(s) could not complete, the following exception(s) have been thrown: " + String.join((CharSequence)";", filterExceptions));
            }
            return result;
        }

        @Generated
        public CompositeOperation(Collection<Operation> operations) {
            this.operations = operations;
        }
    }
}

