/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.zalando.logbook.BaseHttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.servlet.ByteStreams;
import org.zalando.logbook.servlet.FormRequestMode;
import org.zalando.logbook.servlet.ServletInputStreamAdapter;

final class RemoteRequest
extends HttpServletRequestWrapper
implements RawHttpRequest,
HttpRequest {
    private static final byte[] EMPTY_BODY = new byte[0];
    private final FormRequestMode formRequestMode = FormRequestMode.fromProperties();
    @Nullable
    private byte[] body;

    RemoteRequest(HttpServletRequest request) {
        super(request);
    }

    public String getProtocolVersion() {
        return this.getProtocol();
    }

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public String getRemote() {
        return this.getRemoteAddr();
    }

    public String getHost() {
        return this.getServerName();
    }

    public Optional<Integer> getPort() {
        return Optional.of(this.getServerPort());
    }

    public String getPath() {
        return this.getRequestURI();
    }

    public String getQuery() {
        return Optional.ofNullable(this.getQueryString()).orElse("");
    }

    public Map<String, List<String>> getHeaders() {
        BaseHttpMessage.HeadersBuilder builder = new BaseHttpMessage.HeadersBuilder();
        Enumeration names = this.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            builder.put(name, Collections.list(this.getHeaders(name)));
        }
        return builder.build();
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.getCharacterEncoding()).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }

    public HttpRequest withBody() throws IOException {
        if (this.isFormRequest()) {
            switch (this.formRequestMode) {
                case PARAMETER: {
                    this.body = this.reconstructBodyFromParameters();
                    return this;
                }
                case OFF: {
                    this.body = EMPTY_BODY;
                    return this;
                }
            }
        }
        this.body = ByteStreams.toByteArray((InputStream)super.getInputStream());
        return this;
    }

    private boolean isFormRequest() {
        return "application/x-www-form-urlencoded".equals(this.getContentType());
    }

    private byte[] reconstructBodyFromParameters() {
        return this.getParameterMap().entrySet().stream().flatMap(entry -> Arrays.stream((Object[])entry.getValue()).map(value -> RemoteRequest.encode((String)entry.getKey()) + "=" + RemoteRequest.encode(value))).collect(Collectors.joining("&")).getBytes(StandardCharsets.UTF_8);
    }

    private static String encode(String s) {
        return RemoteRequest.encode(s, "UTF-8");
    }

    static String encode(String s, String charset) {
        return URLEncoder.encode(s, charset);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.body == null ? super.getInputStream() : new ServletInputStreamAdapter(new ByteArrayInputStream(this.body));
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharset()));
    }

    public byte[] getBody() {
        return this.body;
    }
}

