/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.common;

import java.util.Objects;
import org.apiguardian.api.API;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.zalando.problem.StatusType;

@API(status=API.Status.EXPERIMENTAL)
public final class HttpStatusAdapter
implements StatusType {
    private HttpStatusCode status;
    private String reason;

    public HttpStatusAdapter(HttpStatusCode status) {
        this.status = status;
        if (status instanceof HttpStatus) {
            this.reason = ((HttpStatus)status).getReasonPhrase();
        }
    }

    public int getStatusCode() {
        return this.status.value();
    }

    public String getReasonPhrase() {
        return this.reason;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof HttpStatusAdapter) {
            HttpStatusAdapter other = (HttpStatusAdapter)that;
            return Objects.equals(this.status, other.status);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.status);
    }
}

