/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice.validation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.web.advice.validation.BaseValidationAdviceTrait;
import org.zalando.problem.violations.Violation;

@API(status=API.Status.STABLE)
public interface ConstraintViolationAdviceTrait
extends BaseValidationAdviceTrait {
    @API(status=API.Status.INTERNAL)
    @ExceptionHandler
    default public ResponseEntity<Problem> handleConstraintViolation(ConstraintViolationException exception, NativeWebRequest request) {
        List<Violation> violations = exception.getConstraintViolations().stream().map(this::createViolation).collect(Collectors.toList());
        return this.newConstraintViolationProblem((Throwable)exception, violations, request);
    }

    default public Violation createViolation(ConstraintViolation violation) {
        return new Violation(this.formatFieldName(violation.getPropertyPath().toString()), violation.getMessage());
    }
}

