/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import com.google.gag.annotation.remark.Hack;
import com.google.gag.annotation.remark.OhNoYouDidnt;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apiguardian.api.API;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

@API(status=API.Status.STABLE)
@Immutable
public abstract class AbstractThrowableProblem
extends ThrowableProblem {
    private final URI type;
    private final String title;
    private final StatusType status;
    private final String detail;
    private final URI instance;
    private final Map<String, Object> parameters;

    protected AbstractThrowableProblem() {
        this((URI)null);
    }

    protected AbstractThrowableProblem(@Nullable URI type) {
        this(type, null);
    }

    protected AbstractThrowableProblem(@Nullable URI type, @Nullable String title) {
        this(type, title, null);
    }

    protected AbstractThrowableProblem(@Nullable URI type, @Nullable String title, @Nullable StatusType status) {
        this(type, title, status, null);
    }

    protected AbstractThrowableProblem(@Nullable URI type, @Nullable String title, @Nullable StatusType status, @Nullable String detail) {
        this(type, title, status, detail, null);
    }

    protected AbstractThrowableProblem(@Nullable URI type, @Nullable String title, @Nullable StatusType status, @Nullable String detail, @Nullable URI instance) {
        this(type, title, status, detail, instance, null);
    }

    protected AbstractThrowableProblem(@Nullable URI type, @Nullable String title, @Nullable StatusType status, @Nullable String detail, @Nullable URI instance, @Nullable ThrowableProblem cause) {
        this(type, title, status, detail, instance, cause, null);
    }

    protected AbstractThrowableProblem(@Nullable URI type, @Nullable String title, @Nullable StatusType status, @Nullable String detail, @Nullable URI instance, @Nullable ThrowableProblem cause, @Nullable Map<String, Object> parameters) {
        super(cause);
        this.type = Optional.ofNullable(type).orElse(DEFAULT_TYPE);
        this.title = title;
        this.status = status;
        this.detail = detail;
        this.instance = instance;
        this.parameters = Optional.ofNullable(parameters).orElseGet(LinkedHashMap::new);
    }

    @Override
    public URI getType() {
        return this.type;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public StatusType getStatus() {
        return this.status;
    }

    @Override
    public String getDetail() {
        return this.detail;
    }

    @Override
    public URI getInstance() {
        return this.instance;
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @API(status=API.Status.INTERNAL)
    @Hack
    @OhNoYouDidnt
    void set(String key, Object value) {
        this.parameters.put(key, value);
    }
}

