/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.channels.Selector;
import zmq.Msg;
import zmq.SocketBase;
import zmq.ZMQ;
import zmq.poll.PollItem;

class Proxy {
    private State state = State.ACTIVE;

    public static boolean proxy(SocketBase frontend, SocketBase backend, SocketBase capture) {
        return new Proxy().start(frontend, backend, capture, null);
    }

    public static boolean proxy(SocketBase frontend, SocketBase backend, SocketBase capture, SocketBase control) {
        return new Proxy().start(frontend, backend, capture, control);
    }

    private Proxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean start(SocketBase frontend, SocketBase backend, SocketBase capture, SocketBase control) {
        boolean success = true;
        int count = control == null ? 2 : 3;
        PollItem[] items = new PollItem[count];
        items[0] = new PollItem(frontend, 1);
        items[1] = new PollItem(backend, 1);
        if (control != null) {
            items[2] = new PollItem(control, 1);
        }
        PollItem[] itemsout = new PollItem[]{new PollItem(frontend, 2), new PollItem(backend, 2)};
        Selector selector = frontend.getCtx().createSelector();
        try {
            while (this.state != State.TERMINATED) {
                int rc = ZMQ.poll(selector, items, -1L);
                if (rc < 0) {
                    boolean bl = false;
                    return bl;
                }
                if (frontend != backend && (rc = ZMQ.poll(selector, itemsout, 0L)) < 0) {
                    boolean bl = false;
                    return bl;
                }
                if (control != null && items[2].isReadable()) {
                    Msg msg = control.recv(0);
                    if (msg == null) {
                        boolean bl = false;
                        return bl;
                    }
                    int more = control.getSocketOpt(13);
                    if (more < 0) {
                        boolean bl = false;
                        return bl;
                    }
                    success = this.capture(capture, msg, more);
                    if (!success) {
                        boolean bl = false;
                        return bl;
                    }
                    String command = new String(msg.data(), ZMQ.CHARSET);
                    if ("PAUSE".equals(command)) {
                        this.state = State.PAUSED;
                    } else if ("RESUME".equals(command)) {
                        this.state = State.ACTIVE;
                    } else if ("TERMINATE".equals(command)) {
                        this.state = State.TERMINATED;
                    } else {
                        System.out.println("E: invalid command sent to proxy '" + command + "'");
                        assert (false);
                    }
                }
                if (this.process(items[0], itemsout[1], frontend, backend) && !this.forward(frontend, backend, capture)) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.process(items[1], itemsout[0], frontend, backend) || this.forward(backend, frontend, capture)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            frontend.getCtx().closeSelector(selector);
        }
        return true;
    }

    private boolean process(PollItem read, PollItem write, SocketBase frontend, SocketBase backend) {
        return this.state == State.ACTIVE && read.isReadable() && (frontend == backend || write.isWritable());
    }

    private boolean forward(SocketBase from, SocketBase to, SocketBase capture) {
        int more;
        do {
            Msg msg;
            if ((msg = from.recv(0)) == null) {
                return false;
            }
            more = from.getSocketOpt(13);
            if (more < 0) {
                return false;
            }
            boolean success = this.capture(capture, msg, more);
            if (!success) {
                return false;
            }
            success = to.send(msg, more > 0 ? 2 : 0);
            if (success) continue;
            return false;
        } while (more != 0);
        return true;
    }

    private boolean capture(SocketBase capture, Msg msg, int more) {
        Msg ctrl;
        boolean success;
        return capture == null || (success = capture.send(ctrl = new Msg(msg), more > 0 ? 2 : 0));
    }

    public static enum State {
        ACTIVE,
        PAUSED,
        TERMINATED;

    }
}

