/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.concurrent.atomic.AtomicInteger;
import zmq.Ctx;
import zmq.ZError;
import zmq.util.Errno;
import zmq.util.Utils;

final class Signaler
implements Closeable {
    private final Pipe.SinkChannel w;
    private final Pipe.SourceChannel r;
    private final Selector selector;
    private final ByteBuffer wdummy = ByteBuffer.allocate(1);
    private final ByteBuffer rdummy = ByteBuffer.allocate(1);
    private final AtomicInteger wcursor = new AtomicInteger(0);
    private int rcursor = 0;
    private final Errno errno;
    private final int pid;
    private final Ctx ctx;

    Signaler(Ctx ctx, int pid, Errno errno) {
        this.ctx = ctx;
        this.pid = pid;
        this.errno = errno;
        try {
            Pipe pipe = Pipe.open();
            this.r = pipe.source();
            this.w = pipe.sink();
            Utils.unblockSocket(this.w, this.r);
            this.selector = ctx.createSelector();
            this.r.register(this.selector, 1);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        try {
            this.r.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            exception = e;
        }
        try {
            this.w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            exception = e;
        }
        this.ctx.closeSelector(this.selector);
        if (exception != null) {
            throw exception;
        }
    }

    SelectableChannel getFd() {
        return this.r;
    }

    void send() {
        int nbytes = 0;
        do {
            try {
                this.wdummy.clear();
                nbytes = this.w.write(this.wdummy);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ZError.IOException(e);
            }
        } while (nbytes == 0);
        assert (nbytes == 1);
        this.wcursor.incrementAndGet();
    }

    boolean waitEvent(long timeout) {
        boolean brc;
        int rc = 0;
        boolean bl = brc = this.rcursor < this.wcursor.get();
        if (brc) {
            return true;
        }
        try {
            if (timeout == 0L) {
                if (!brc) {
                    this.errno.set(35);
                }
                return brc;
            }
            rc = timeout < 0L ? this.selector.select(0L) : this.selector.select(timeout);
        }
        catch (IOException | ClosedSelectorException e) {
            e.printStackTrace();
            this.errno.set(4);
            return false;
        }
        if (rc == 0) {
            this.errno.set(35);
            return false;
        }
        this.selector.selectedKeys().clear();
        return true;
    }

    void recv() {
        int nbytes = 0;
        while (nbytes == 0) {
            try {
                this.rdummy.clear();
                nbytes = this.r.read(this.rdummy);
            }
            catch (ClosedChannelException e) {
                e.printStackTrace();
                this.errno.set(4);
                return;
            }
            catch (IOException e) {
                throw new ZError.IOException(e);
            }
        }
        assert (nbytes == 1);
        ++this.rcursor;
    }

    public String toString() {
        return "Signaler[" + this.pid + "]";
    }
}

