/*
 * Decompiled with CFR 0.152.
 */
package zmq.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import zmq.Config;
import zmq.Msg;
import zmq.Options;
import zmq.SocketBase;
import zmq.ZError;
import zmq.ZMQ;
import zmq.io.IEngine;
import zmq.io.IOObject;
import zmq.io.IOThread;
import zmq.io.Metadata;
import zmq.io.SessionBase;
import zmq.io.coder.IDecoder;
import zmq.io.coder.IEncoder;
import zmq.io.coder.raw.RawDecoder;
import zmq.io.coder.raw.RawEncoder;
import zmq.io.coder.v1.V1Decoder;
import zmq.io.coder.v1.V1Encoder;
import zmq.io.coder.v2.V2Decoder;
import zmq.io.coder.v2.V2Encoder;
import zmq.io.mechanism.Mechanism;
import zmq.io.mechanism.Mechanisms;
import zmq.io.net.Address;
import zmq.poll.IPollEvents;
import zmq.poll.Poller;
import zmq.util.Blob;
import zmq.util.Errno;
import zmq.util.Utils;
import zmq.util.ValueReference;
import zmq.util.Wire;

public class StreamEngine
implements IEngine,
IPollEvents {
    private IOObject ioObject;
    private SocketChannel fd;
    private Poller.Handle handle;
    private ByteBuffer inpos;
    private int insize;
    private IDecoder decoder;
    private final ValueReference<ByteBuffer> outpos;
    private int outsize;
    private IEncoder encoder;
    private Metadata metadata;
    private boolean handshaking;
    private static final int SIGNATURE_SIZE = 10;
    private static final int V2_GREETING_SIZE = 12;
    private static final int V3_GREETING_SIZE = 64;
    private int greetingSize;
    private final ByteBuffer greetingRecv;
    private final ByteBuffer greetingSend;
    private Protocol zmtpVersion;
    private SessionBase session;
    private Options options;
    private String endpoint;
    private boolean plugged;
    private MessageProcessor nextMsg;
    private MessageProcessor processMsg;
    private boolean ioError;
    private boolean subscriptionRequired;
    private Mechanism mechanism;
    private boolean inputStopped;
    private boolean outputStopped;
    private static final int HANDSHAKE_TIMER_ID = 64;
    private boolean hasHandshakeTimer;
    private SocketBase socket;
    private Address peerAddress;
    private final Errno errno;
    private final MessageProcessor identity = new Identity();
    private final MessageProcessor processHandshakeCommand;
    private final MessageProcessor nextHandshakeCommand = this.processHandshakeCommand = new HandshakeCommand();
    private final MessageProcessor pushMsgToSession;
    private final MessageProcessor pullMsgFromSession = this.pushMsgToSession = new PushMsgToSession();
    private final MessageProcessor pushRawMsgToSession = new PushRawMsgToSession();
    private final MessageProcessor writeCredential = new WriteCredential();
    private final MessageProcessor pullAndEncode = new PullAndEncode();
    private final MessageProcessor decodeAndPush = new DecodeAndPush();
    private final MessageProcessor pushOneThenDecodeAndPush = new PushOneThenDecodeAndPush();

    public StreamEngine(SocketChannel fd, Options options, String endpoint) {
        this.errno = options.errno;
        this.fd = fd;
        this.handshaking = true;
        this.greetingSize = 12;
        this.options = options;
        this.endpoint = endpoint;
        this.nextMsg = this.identity;
        this.processMsg = this.identity;
        this.outpos = new ValueReference();
        this.greetingRecv = ByteBuffer.allocate(64);
        this.greetingSend = ByteBuffer.allocate(64);
        try {
            Utils.unblockSocket(this.fd);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        this.peerAddress = Utils.getPeerIpAddress(fd);
    }

    public void destroy() {
        assert (!this.plugged);
        if (this.fd != null) {
            block7: {
                try {
                    this.fd.close();
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
            this.fd = null;
        }
        if (this.encoder != null) {
            this.encoder.destroy();
        }
        if (this.decoder != null) {
            this.decoder.destroy();
        }
        if (this.mechanism != null) {
            this.mechanism.destroy();
        }
    }

    @Override
    public void plug(IOThread ioThread, SessionBase session) {
        assert (!this.plugged);
        this.plugged = true;
        assert (this.session == null);
        assert (session != null);
        this.session = session;
        this.socket = session.getSocket();
        this.ioObject = new IOObject(ioThread, this);
        this.ioObject.plug();
        this.handle = this.ioObject.addFd(this.fd);
        this.ioError = false;
        if (this.options.rawSocket) {
            this.decoder = (IDecoder)this.instantiate(this.options.decoder, Config.IN_BATCH_SIZE.getValue(), this.options.maxMsgSize);
            if (this.decoder == null) {
                this.decoder = new RawDecoder(Config.IN_BATCH_SIZE.getValue());
            }
            this.encoder = (IEncoder)this.instantiate(this.options.encoder, Config.OUT_BATCH_SIZE.getValue(), this.options.maxMsgSize);
            if (this.encoder == null) {
                this.encoder = new RawEncoder(this.errno, Config.OUT_BATCH_SIZE.getValue());
            }
            this.handshaking = false;
            this.nextMsg = this.pullMsgFromSession;
            this.processMsg = this.pushRawMsgToSession;
            if (this.peerAddress != null && !this.peerAddress.address().isEmpty()) {
                assert (this.metadata == null);
                this.metadata = new Metadata();
                this.metadata.set("Peer-Address", this.peerAddress.address());
            }
            Msg connector = new Msg();
            this.pushRawMsgToSession(connector);
            session.flush();
        } else {
            this.setHandshakeTimer();
            this.greetingSend.put((byte)-1);
            Wire.putUInt64(this.greetingSend, this.options.identitySize + 1);
            this.greetingSend.put((byte)127);
            this.outpos.set(this.greetingSend);
            this.outsize = this.greetingSend.position();
            this.greetingSend.flip();
        }
        this.ioObject.setPollIn(this.handle);
        this.ioObject.setPollOut(this.handle);
        this.inEvent();
    }

    private Object instantiate(Class<?> decoder, int size, long max) {
        if (decoder == null) {
            return null;
        }
        try {
            return decoder.getConstructor(Integer.TYPE, Long.TYPE).newInstance(size, max);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void unplug() {
        assert (this.plugged);
        this.plugged = false;
        if (this.hasHandshakeTimer) {
            this.ioObject.cancelTimer(64);
            this.hasHandshakeTimer = false;
        }
        if (!this.ioError) {
            this.ioObject.removeHandle(this.handle);
            this.handle = null;
        }
        this.ioObject.unplug();
        this.session = null;
    }

    @Override
    public void terminate() {
        this.unplug();
        this.destroy();
    }

    @Override
    public void inEvent() {
        int rc;
        assert (!this.ioError);
        if (this.handshaking && !this.handshake()) {
            return;
        }
        assert (this.decoder != null);
        if (this.inputStopped) {
            this.ioObject.removeHandle(this.handle);
            this.handle = null;
            this.ioError = true;
            return;
        }
        if (this.insize == 0) {
            this.inpos = this.decoder.getBuffer();
            rc = this.read(this.inpos);
            if (rc == 0) {
                this.error(ErrorReason.CONNECTION);
            }
            if (rc == -1) {
                if (!this.errno.is(35)) {
                    this.error(ErrorReason.CONNECTION);
                }
                return;
            }
            this.inpos.flip();
            this.insize = rc;
        }
        rc = 0;
        ValueReference<Integer> processed = new ValueReference<Integer>(0);
        while (this.insize > 0) {
            IDecoder.Step.Result result = this.decoder.decode(this.inpos, this.insize, processed);
            assert (processed.get() <= this.insize);
            this.insize -= processed.get().intValue();
            if (result == IDecoder.Step.Result.MORE_DATA) {
                rc = 1;
                break;
            }
            if (result == IDecoder.Step.Result.ERROR) {
                rc = 0;
                break;
            }
            Msg msg = this.decoder.msg();
            rc = this.processMsg.processMsg(msg) ? 1 : 0;
            if (rc != 0) continue;
            break;
        }
        if (rc == 0) {
            if (!this.errno.is(35)) {
                this.error(ErrorReason.PROTOCOL);
                return;
            }
            this.inputStopped = true;
            this.ioObject.resetPollIn(this.handle);
        }
        this.session.flush();
    }

    @Override
    public void outEvent() {
        int nbytes;
        assert (!this.ioError);
        if (this.outsize == 0) {
            Msg msg;
            if (this.encoder == null) {
                assert (this.handshaking);
                return;
            }
            this.outpos.set(null);
            this.outsize = this.encoder.encode(this.outpos, 0);
            while (this.outsize < Config.OUT_BATCH_SIZE.getValue() && (msg = this.nextMsg.nextMsg()) != null) {
                this.encoder.loadMsg(msg);
                int n = this.encoder.encode(this.outpos, Config.OUT_BATCH_SIZE.getValue() - this.outsize);
                assert (n > 0);
                this.outsize += n;
            }
            if (this.outsize == 0) {
                this.outputStopped = true;
                this.ioObject.resetPollOut(this.handle);
                return;
            }
            ByteBuffer buf = this.outpos.get();
            assert (buf != null);
            if (this.outsize <= Config.OUT_BATCH_SIZE.getValue()) {
                buf.flip();
            }
        }
        if ((nbytes = this.write(this.outpos.get())) == -1) {
            this.ioObject.resetPollOut(this.handle);
            return;
        }
        this.outsize -= nbytes;
        if (this.handshaking && this.outsize == 0) {
            this.ioObject.resetPollOut(this.handle);
        }
    }

    @Override
    public void restartOutput() {
        if (this.ioError) {
            return;
        }
        if (this.outputStopped) {
            this.ioObject.setPollOut(this.handle);
            this.outputStopped = false;
        }
        this.outEvent();
    }

    @Override
    public void restartInput() {
        assert (this.inputStopped);
        assert (this.session != null);
        assert (this.decoder != null);
        boolean rc = false;
        Msg msg = this.decoder.msg();
        rc = this.processMsg.processMsg(msg);
        if (!rc) {
            if (this.errno.is(35)) {
                this.session.flush();
            } else {
                this.error(ErrorReason.PROTOCOL);
            }
            return;
        }
        while (this.insize > 0) {
            ValueReference<Integer> processed = new ValueReference<Integer>(0);
            IDecoder.Step.Result result = this.decoder.decode(this.inpos, this.insize, processed);
            assert (processed.get() <= this.insize);
            this.insize -= processed.get().intValue();
            if (result == IDecoder.Step.Result.MORE_DATA) {
                rc = true;
                break;
            }
            if (result == IDecoder.Step.Result.ERROR) {
                rc = false;
                break;
            }
            msg = this.decoder.msg();
            rc = this.processMsg.processMsg(msg);
            if (rc) continue;
            break;
        }
        if (!rc && this.errno.is(35)) {
            this.session.flush();
        } else if (this.ioError) {
            this.error(ErrorReason.CONNECTION);
        } else if (!rc) {
            this.error(ErrorReason.PROTOCOL);
        } else {
            this.inputStopped = false;
            this.ioObject.setPollIn(this.handle);
            this.session.flush();
            this.inEvent();
        }
    }

    private boolean handshake() {
        assert (this.handshaking);
        assert (this.greetingRecv.position() < this.greetingSize);
        int revisionPos = 10;
        while (this.greetingRecv.position() < this.greetingSize) {
            int n = this.read(this.greetingRecv);
            if (n == 0) {
                this.error(ErrorReason.CONNECTION);
                return false;
            }
            if (n == -1) {
                if (!this.errno.is(35)) {
                    this.error(ErrorReason.CONNECTION);
                }
                return false;
            }
            if ((this.greetingRecv.get(0) & 0xFF) != 255) break;
            if (this.greetingRecv.position() < 10) continue;
            if ((this.greetingRecv.get(9) & 1) != 1) break;
            int outpos = this.greetingSend.position();
            if (this.greetingSend.limit() == 10) {
                if (this.outsize == 0) {
                    this.ioObject.setPollOut(this.handle);
                }
                this.greetingSend.limit(11);
                this.greetingSend.put(10, Protocol.V3.revision);
                ++this.outsize;
            }
            if (this.greetingRecv.position() > 10 && this.greetingSend.limit() == 11) {
                byte protocol;
                if (this.outsize == 0) {
                    this.ioObject.setPollOut(this.handle);
                }
                if ((protocol = this.greetingRecv.get(10)) == Protocol.V1.revision || protocol == Protocol.V2.revision) {
                    this.greetingSend.limit(12);
                    this.greetingSend.position(11);
                    this.greetingSend.put((byte)this.options.type);
                    ++this.outsize;
                } else {
                    this.greetingSend.limit(64);
                    this.greetingSend.position(11);
                    this.greetingSend.put((byte)0);
                    ++this.outsize;
                    this.greetingSend.mark();
                    this.greetingSend.put(new byte[20]);
                    assert (this.options.mechanism == Mechanisms.NULL || this.options.mechanism == Mechanisms.PLAIN || this.options.mechanism == Mechanisms.CURVE || this.options.mechanism == Mechanisms.GSSAPI);
                    this.greetingSend.reset();
                    this.greetingSend.put(this.options.mechanism.name().getBytes(ZMQ.CHARSET));
                    this.greetingSend.reset();
                    this.greetingSend.position(this.greetingSend.position() + 20);
                    this.outsize += 20;
                    this.greetingSend.put(new byte[32]);
                    this.outsize += 32;
                    this.greetingSize = 64;
                }
            }
            this.greetingSend.position(outpos);
        }
        if ((this.greetingRecv.get(0) & 0xFF) != 255 || (this.greetingRecv.get(9) & 1) == 0) {
            if (this.session.zapEnabled()) {
                this.error(ErrorReason.PROTOCOL);
                return false;
            }
            this.zmtpVersion = Protocol.V0;
            this.encoder = new V1Encoder(this.errno, Config.OUT_BATCH_SIZE.getValue());
            this.decoder = new V1Decoder(this.errno, Config.IN_BATCH_SIZE.getValue(), this.options.maxMsgSize, this.options.allocationHeapThreshold);
            int headerSize = this.options.identitySize + 1 >= 255 ? 10 : 2;
            ByteBuffer tmp = ByteBuffer.allocate(headerSize);
            Msg txMsg = new Msg(this.options.identitySize);
            txMsg.put(this.options.identity, 0, (int)this.options.identitySize);
            this.encoder.loadMsg(txMsg);
            ValueReference<ByteBuffer> bufferp = new ValueReference<ByteBuffer>(tmp);
            int bufferSize = this.encoder.encode(bufferp, headerSize);
            assert (bufferSize == headerSize);
            this.greetingRecv.flip();
            this.inpos = this.greetingRecv;
            this.insize = this.greetingRecv.limit();
            if (this.options.type == 1 || this.options.type == 9) {
                this.subscriptionRequired = true;
            }
            this.nextMsg = this.pullMsgFromSession;
            this.processMsg = this.identity;
        } else if (this.greetingRecv.get(10) == Protocol.V1.revision) {
            this.zmtpVersion = Protocol.V1;
            if (this.session.zapEnabled()) {
                this.error(ErrorReason.PROTOCOL);
                return false;
            }
            this.encoder = new V1Encoder(this.errno, Config.OUT_BATCH_SIZE.getValue());
            this.decoder = new V1Decoder(this.errno, Config.IN_BATCH_SIZE.getValue(), this.options.maxMsgSize, this.options.allocationHeapThreshold);
        } else if (this.greetingRecv.get(10) == Protocol.V2.revision) {
            this.zmtpVersion = Protocol.V2;
            if (this.session.zapEnabled()) {
                this.error(ErrorReason.PROTOCOL);
                return false;
            }
            this.encoder = new V2Encoder(this.errno, Config.OUT_BATCH_SIZE.getValue());
            this.decoder = new V2Decoder(this.errno, Config.IN_BATCH_SIZE.getValue(), this.options.maxMsgSize, this.options.allocationHeapThreshold);
        } else {
            this.zmtpVersion = Protocol.V3;
            this.encoder = new V2Encoder(this.errno, Config.OUT_BATCH_SIZE.getValue());
            this.decoder = new V2Decoder(this.errno, Config.IN_BATCH_SIZE.getValue(), this.options.maxMsgSize, this.options.allocationHeapThreshold);
            this.greetingRecv.position(12);
            if (this.options.mechanism == null) {
                this.error(ErrorReason.PROTOCOL);
                return false;
            }
            if (!this.options.mechanism.isMechanism(this.greetingRecv)) {
                this.error(ErrorReason.PROTOCOL);
                return false;
            }
            this.mechanism = this.options.mechanism.create(this.session, this.peerAddress, this.options);
            this.nextMsg = this.nextHandshakeCommand;
            this.processMsg = this.processHandshakeCommand;
        }
        if (this.outsize == 0) {
            this.ioObject.setPollOut(this.handle);
        }
        this.handshaking = false;
        if (this.hasHandshakeTimer) {
            this.ioObject.cancelTimer(64);
            this.hasHandshakeTimer = false;
        }
        return true;
    }

    private Msg identityMsg() {
        Msg msg = new Msg(this.options.identitySize);
        if (this.options.identitySize > 0) {
            msg.put(this.options.identity, 0, (int)this.options.identitySize);
        }
        this.nextMsg = this.pullMsgFromSession;
        return msg;
    }

    private boolean processIdentityMsg(Msg msg) {
        if (this.options.recvIdentity) {
            msg.setFlags(64);
            boolean rc = this.session.pushMsg(msg);
            assert (rc);
        }
        if (this.subscriptionRequired) {
            Msg subscription = new Msg(1);
            subscription.put((byte)1);
            boolean rc = this.session.pushMsg(subscription);
            assert (rc);
        }
        this.processMsg = this.pushMsgToSession;
        return true;
    }

    private Msg nextHandshakeCommand() {
        assert (this.mechanism != null);
        if (this.mechanism.status() == Mechanism.Status.READY) {
            this.mechanismReady();
            return this.pullAndEncode.nextMsg();
        }
        if (this.mechanism.status() == Mechanism.Status.ERROR) {
            this.errno.set(156384820);
            return null;
        }
        Msg.Builder msg = new Msg.Builder();
        int rc = this.mechanism.nextHandshakeCommand(msg);
        if (rc == 0) {
            msg.setFlags(2);
            return msg.build();
        }
        this.errno.set(rc);
        return null;
    }

    private boolean processHandshakeCommand(Msg msg) {
        assert (this.mechanism != null);
        int rc = this.mechanism.processHandshakeCommand(msg);
        if (rc == 0) {
            if (this.mechanism.status() == Mechanism.Status.READY) {
                this.mechanismReady();
            } else if (this.mechanism.status() == Mechanism.Status.ERROR) {
                this.errno.set(156384820);
                return false;
            }
            if (this.outputStopped) {
                this.restartOutput();
            }
        } else {
            this.errno.set(rc);
        }
        return rc == 0;
    }

    @Override
    public void zapMsgAvailable() {
        assert (this.mechanism != null);
        int rc = this.mechanism.zapMsgAvailable();
        if (rc == -1) {
            this.error(ErrorReason.PROTOCOL);
            return;
        }
        if (this.inputStopped) {
            this.restartInput();
        }
        if (this.outputStopped) {
            this.restartOutput();
        }
    }

    private void mechanismReady() {
        if (this.options.recvIdentity) {
            Msg identity = this.mechanism.peerIdentity();
            boolean rc = this.session.pushMsg(identity);
            if (!rc && this.errno.is(35)) {
                return;
            }
            assert (rc);
            this.session.flush();
        }
        this.nextMsg = this.pullAndEncode;
        this.processMsg = this.writeCredential;
        assert (this.metadata == null);
        this.metadata = new Metadata();
        if (this.peerAddress != null && !this.peerAddress.address().isEmpty()) {
            this.metadata.set("Peer-Address", this.peerAddress.address());
        }
        this.metadata.set(this.mechanism.zapProperties);
        this.metadata.set(this.mechanism.zmtpProperties);
        if (this.metadata.isEmpty()) {
            this.metadata = null;
        }
    }

    private Msg pullMsgFromSession() {
        return this.session.pullMsg();
    }

    private boolean pushMsgToSession(Msg msg) {
        return this.session.pushMsg(msg);
    }

    private boolean pushRawMsgToSession(Msg msg) {
        if (this.metadata != null && !this.metadata.equals(msg.getMetadata())) {
            msg.setMetadata(this.metadata);
        }
        return this.pushMsgToSession(msg);
    }

    private boolean writeCredential(Msg msg) {
        assert (this.mechanism != null);
        assert (this.session != null);
        Blob credential = this.mechanism.getUserId();
        if (credential != null && credential.size() > 0) {
            Msg cred = new Msg(credential.size());
            cred.put(credential.data(), 0, credential.size());
            cred.setFlags(32);
            boolean rc = this.session.pushMsg(cred);
            if (!rc) {
                return false;
            }
        }
        this.processMsg = this.decodeAndPush;
        return this.decodeAndPush.processMsg(msg);
    }

    private void error(ErrorReason error) {
        if (this.options.rawSocket) {
            Msg terminator = new Msg();
            this.processMsg.processMsg(terminator);
        }
        assert (this.session != null);
        this.socket.eventDisconnected(this.endpoint, this.fd);
        this.session.flush();
        this.session.engineError(error);
        this.unplug();
        this.destroy();
    }

    private void setHandshakeTimer() {
        assert (!this.hasHandshakeTimer);
        if (!this.options.rawSocket && this.options.handshakeIvl > 0) {
            this.ioObject.addTimer(this.options.handshakeIvl, 64);
            this.hasHandshakeTimer = true;
        }
    }

    @Override
    public void timerEvent(int id) {
        assert (id == 64);
        this.hasHandshakeTimer = false;
        this.error(ErrorReason.TIMEOUT);
    }

    private int write(ByteBuffer outbuf) {
        int nbytes;
        try {
            nbytes = this.fd.write(outbuf);
            if (nbytes == 0) {
                this.errno.set(35);
            }
        }
        catch (IOException e) {
            this.errno.set(57);
            nbytes = -1;
        }
        return nbytes;
    }

    private int read(ByteBuffer buf) {
        int nbytes;
        try {
            nbytes = this.fd.read(buf);
            if (nbytes == -1) {
                this.errno.set(57);
            } else if (nbytes == 0 && !this.fd.isBlocking()) {
                this.errno.set(35);
                nbytes = -1;
            }
        }
        catch (IOException e) {
            this.errno.set(57);
            nbytes = -1;
        }
        return nbytes;
    }

    @Override
    public void connectEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptEvent() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.socket + "-" + (Object)((Object)this.zmtpVersion);
    }

    public static enum ErrorReason {
        PROTOCOL,
        CONNECTION,
        TIMEOUT;

    }

    private static enum Protocol {
        V0(0),
        V1(1),
        V2(2),
        V3(3);

        private final byte revision;

        private Protocol(int revision) {
            this.revision = (byte)revision;
        }
    }

    private static interface MessageProcessor {
        public Msg nextMsg();

        public boolean processMsg(Msg var1);

        public static class Adapter
        implements MessageProcessor {
            @Override
            public Msg nextMsg() {
                throw new UnsupportedOperationException("nextMsg is not implemented and should not be used here");
            }

            @Override
            public boolean processMsg(Msg msg) {
                throw new UnsupportedOperationException("processMsg is not implemented and should not be used here");
            }
        }
    }

    private final class Identity
    implements MessageProcessor {
        private Identity() {
        }

        @Override
        public Msg nextMsg() {
            return StreamEngine.this.identityMsg();
        }

        @Override
        public boolean processMsg(Msg msg) {
            return StreamEngine.this.processIdentityMsg(msg);
        }
    }

    private final class PushOneThenDecodeAndPush
    extends MessageProcessor.Adapter {
        private PushOneThenDecodeAndPush() {
        }

        @Override
        public boolean processMsg(Msg msg) {
            boolean rc = StreamEngine.this.session.pushMsg(msg);
            if (rc) {
                StreamEngine.this.processMsg = StreamEngine.this.decodeAndPush;
            }
            return rc;
        }
    }

    private final class PullAndEncode
    extends MessageProcessor.Adapter {
        private PullAndEncode() {
        }

        @Override
        public Msg nextMsg() {
            assert (StreamEngine.this.mechanism != null);
            Msg msg = StreamEngine.this.session.pullMsg();
            if (msg == null) {
                return null;
            }
            msg = StreamEngine.this.mechanism.encode(msg);
            return msg;
        }
    }

    private final class DecodeAndPush
    extends MessageProcessor.Adapter {
        private DecodeAndPush() {
        }

        @Override
        public boolean processMsg(Msg msg) {
            boolean rc;
            assert (StreamEngine.this.mechanism != null);
            msg = StreamEngine.this.mechanism.decode(msg);
            if (msg == null) {
                return false;
            }
            if (StreamEngine.this.metadata != null) {
                msg.setMetadata(StreamEngine.this.metadata);
            }
            if (!(rc = StreamEngine.this.session.pushMsg(msg))) {
                if (StreamEngine.this.errno.is(35)) {
                    StreamEngine.this.processMsg = StreamEngine.this.pushOneThenDecodeAndPush;
                }
                return false;
            }
            return true;
        }
    }

    private final class WriteCredential
    extends MessageProcessor.Adapter {
        private WriteCredential() {
        }

        @Override
        public boolean processMsg(Msg msg) {
            return StreamEngine.this.writeCredential(msg);
        }
    }

    private final class PushRawMsgToSession
    extends MessageProcessor.Adapter {
        private PushRawMsgToSession() {
        }

        @Override
        public boolean processMsg(Msg msg) {
            return StreamEngine.this.pushRawMsgToSession(msg);
        }
    }

    private final class PushMsgToSession
    extends MessageProcessor.Adapter {
        private PushMsgToSession() {
        }

        @Override
        public Msg nextMsg() {
            return StreamEngine.this.pullMsgFromSession();
        }

        @Override
        public boolean processMsg(Msg msg) {
            return StreamEngine.this.pushMsgToSession(msg);
        }
    }

    private final class HandshakeCommand
    extends MessageProcessor.Adapter {
        private HandshakeCommand() {
        }

        @Override
        public Msg nextMsg() {
            return StreamEngine.this.nextHandshakeCommand();
        }

        @Override
        public boolean processMsg(Msg msg) {
            return StreamEngine.this.processHandshakeCommand(msg);
        }
    }
}

