/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.coder.v2;

import java.nio.ByteBuffer;
import zmq.Msg;
import zmq.io.coder.Decoder;
import zmq.io.coder.IDecoder;
import zmq.util.Errno;
import zmq.util.Wire;

public class V2Decoder
extends Decoder {
    private final ByteBuffer tmpbuf = ByteBuffer.allocate(8);

    public V2Decoder(Errno errno, int bufsize, long maxmsgsize, int allocationHeapThreshold) {
        super(errno, bufsize, maxmsgsize, allocationHeapThreshold);
        this.tmpbuf.limit(1);
        this.nextStep(this.tmpbuf, this.flagsReady);
    }

    @Override
    protected IDecoder.Step.Result oneByteSizeReady() {
        int size = this.tmpbuf.get(0) & 0xFF;
        IDecoder.Step.Result rc = this.sizeReady(size);
        if (rc != IDecoder.Step.Result.ERROR) {
            this.nextStep(this.inProgress, this.messageReady);
        }
        return rc;
    }

    @Override
    protected IDecoder.Step.Result eightByteSizeReady() {
        this.tmpbuf.position(0);
        this.tmpbuf.limit(8);
        long size = Wire.getUInt64(this.tmpbuf, 0);
        IDecoder.Step.Result rc = this.sizeReady(size);
        if (rc != IDecoder.Step.Result.ERROR) {
            this.nextStep(this.inProgress, this.messageReady);
        }
        return rc;
    }

    @Override
    protected IDecoder.Step.Result flagsReady() {
        this.msgFlags = 0;
        int first = this.tmpbuf.get(0) & 0xFF;
        if ((first & 1) > 0) {
            this.msgFlags |= 1;
        }
        if ((first & 4) > 0) {
            this.msgFlags |= 2;
        }
        this.tmpbuf.position(0);
        if ((first & 2) > 0) {
            this.tmpbuf.limit(8);
            this.nextStep(this.tmpbuf, this.eightByteSizeReady);
        } else {
            this.tmpbuf.limit(1);
            this.nextStep(this.tmpbuf, this.oneByteSizeReady);
        }
        return IDecoder.Step.Result.MORE_DATA;
    }

    @Override
    protected IDecoder.Step.Result messageReady() {
        this.tmpbuf.position(0);
        this.tmpbuf.limit(1);
        this.nextStep(this.tmpbuf, this.flagsReady);
        return IDecoder.Step.Result.DECODED;
    }

    @Override
    protected long binarySize(Msg msg) {
        return msg.size() + this.tmpbuf.limit() + 1;
    }
}

