/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.mechanism;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zmq.Msg;
import zmq.Options;
import zmq.ZMQ;
import zmq.io.Metadata;
import zmq.io.SessionBase;
import zmq.io.mechanism.Mechanisms;
import zmq.io.net.Address;
import zmq.socket.Sockets;
import zmq.util.Blob;
import zmq.util.Wire;

public abstract class Mechanism {
    protected static final String IDENTITY = "Identity";
    protected static final String SOCKET_TYPE = "Socket-Type";
    protected final Options options;
    private Blob identity;
    private Blob userId;
    public final Metadata zapProperties = new Metadata();
    public final Metadata zmtpProperties = new Metadata();
    protected final SessionBase session;
    private final Address peerAddress;
    protected String statusCode;

    protected Mechanism(SessionBase session, Address peerAddress, Options options) {
        this.session = session;
        this.options = options;
        this.peerAddress = peerAddress;
    }

    public abstract Status status();

    void setPeerIdentity(String data) {
        this.identity = Blob.createBlob(data.getBytes(ZMQ.CHARSET));
    }

    public Msg peerIdentity() {
        Msg msg = new Msg(this.identity == null ? 0 : this.identity.size());
        msg.put(this.identity.data(), 0, this.identity.size());
        msg.setFlags(64);
        return msg;
    }

    void setUserId(byte[] data) {
        this.userId = Blob.createBlob(data);
        this.zapProperties.set("User-Id", new String(data, ZMQ.CHARSET));
    }

    public Blob getUserId() {
        return this.userId;
    }

    protected void addProperty(ByteBuffer buf, String name, String value) {
        this.addProperty(buf, name, value.getBytes(ZMQ.CHARSET));
    }

    protected void addProperty(Msg msg, String name, String value) {
        this.addProperty(msg, name, value.getBytes(ZMQ.CHARSET));
    }

    protected void addProperty(ByteBuffer buf, String name, byte[] value) {
        int valueLength;
        byte[] nameB = name.getBytes(ZMQ.CHARSET);
        int nameLength = nameB.length;
        assert (nameLength <= 255);
        int n = valueLength = value == null ? 0 : value.length;
        assert (valueLength <= Integer.MAX_VALUE);
        buf.put((byte)nameLength);
        buf.put(nameB);
        Wire.putUInt32(buf, valueLength);
        if (value != null) {
            buf.put(value);
        }
    }

    protected void addProperty(Msg msg, String name, byte[] value) {
        int valueLength;
        byte[] nameB = name.getBytes(ZMQ.CHARSET);
        int nameLength = nameB.length;
        assert (nameLength <= 255);
        int n = valueLength = value == null ? 0 : value.length;
        assert (valueLength <= Integer.MAX_VALUE);
        msg.put((byte)nameLength);
        msg.put(nameB);
        Wire.putUInt32(msg, valueLength);
        if (value != null) {
            msg.put(value);
        }
    }

    protected int parseMetadata(Msg msg, int offset, boolean zapFlag) {
        return this.parseMetadata(msg.buf(), offset, zapFlag);
    }

    protected int parseMetadata(ByteBuffer msg, int offset, boolean zapFlag) {
        ByteBuffer data = msg.duplicate();
        data.position(offset);
        int bytesLeft = data.remaining();
        int index = offset;
        while (bytesLeft > 1) {
            byte nameLength = data.get(index);
            ++index;
            if (--bytesLeft < nameLength) break;
            String name = this.build(data, index, nameLength);
            index += nameLength;
            if ((bytesLeft -= nameLength) < 4) break;
            int valueLength = Wire.getUInt32(data, index);
            index += 4;
            if ((bytesLeft -= 4) < valueLength) break;
            String value = this.build(data, index, valueLength);
            index += valueLength;
            bytesLeft -= valueLength;
            if (IDENTITY.equals(name) && this.options.recvIdentity) {
                this.setPeerIdentity(value);
            } else if (SOCKET_TYPE.equals(name)) {
                if (!Sockets.compatible(this.options.type, value)) {
                    return 22;
                }
            } else {
                int rc = this.property(name, value);
                if (rc == -1) {
                    return -1;
                }
            }
            if (zapFlag) {
                this.zapProperties.set(name, value);
                continue;
            }
            this.zmtpProperties.set(name, value);
        }
        if (bytesLeft > 0) {
            return 156384820;
        }
        return 0;
    }

    private String build(ByteBuffer buf, int offset, int length) {
        byte[] bytes = new byte[length];
        int position = buf.position();
        buf.position(offset);
        buf.get(bytes, 0, length);
        buf.position(position);
        return new String(bytes, ZMQ.CHARSET);
    }

    protected int property(String name, String value) {
        return 0;
    }

    protected String socketType(int socketType) {
        return Sockets.name(this.options.type);
    }

    protected boolean compare(Msg msg, String data, boolean includeLength) {
        boolean comparison;
        int start;
        int n = start = includeLength ? 1 : 0;
        if (msg.size() < data.length() + start) {
            return false;
        }
        boolean bl = includeLength ? msg.get(0) == data.length() : (comparison = true);
        if (comparison) {
            for (int idx = start; idx < data.length() && (comparison &= msg.get(idx) == data.charAt(idx - start)); ++idx) {
            }
        }
        return comparison;
    }

    protected boolean compare(ByteBuffer a1, byte[] b, int offset, int length) {
        if (length > b.length) {
            return false;
        }
        boolean comparison = true;
        for (int idx = 0; idx < length && (comparison |= a1.get(idx + offset) == b[idx]); ++idx) {
        }
        return comparison;
    }

    public Msg decode(Msg msg) {
        return msg;
    }

    public Msg encode(Msg msg) {
        return msg;
    }

    public abstract int zapMsgAvailable();

    public abstract int processHandshakeCommand(Msg var1);

    public abstract int nextHandshakeCommand(Msg var1);

    protected void sendZapRequest(Mechanisms mechanism, boolean more) {
        assert (this.session != null);
        assert (this.peerAddress != null);
        assert (mechanism != null);
        Msg msg = new Msg();
        msg.setFlags(1);
        boolean rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(3);
        msg.setFlags(1);
        msg.put("1.0".getBytes(ZMQ.CHARSET));
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(1);
        msg.setFlags(1);
        msg.put("1".getBytes(ZMQ.CHARSET));
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(this.options.zapDomain.length());
        msg.setFlags(1);
        msg.put(this.options.zapDomain.getBytes(ZMQ.CHARSET));
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(this.peerAddress.address().length());
        msg.setFlags(1);
        msg.put(this.peerAddress.address().getBytes(ZMQ.CHARSET));
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(this.options.identitySize);
        msg.setFlags(1);
        msg.put(this.options.identity, 0, (int)this.options.identitySize);
        rc = this.session.writeZapMsg(msg);
        assert (rc);
        msg = new Msg(mechanism.name().length());
        msg.put(mechanism.name().getBytes(ZMQ.CHARSET));
        if (more) {
            msg.setFlags(1);
        }
        rc = this.session.writeZapMsg(msg);
        assert (rc);
    }

    protected int receiveAndProcessZapReply() {
        assert (this.session != null);
        ArrayList<Msg> msgs = new ArrayList<Msg>(7);
        for (int idx = 0; idx < 7; ++idx) {
            Msg msg = this.session.readZapMsg();
            if (msg == null) {
                return this.session.errno.get();
            }
            if ((msg.flags() & 1) == (idx < 6 ? 0 : 1)) {
                this.puts("NULL I: ZAP handler sent incomplete reply message " + msg);
                return 156384820;
            }
            msgs.add(msg);
        }
        if (((Msg)msgs.get(0)).size() > 0) {
            this.puts("NULL I: ZAP handler sent malformed reply message in address delimiter frame " + msgs.get(0));
            return 156384820;
        }
        if (((Msg)msgs.get(1)).size() != 3 || !this.compare((Msg)msgs.get(1), "1.0", false)) {
            this.puts("NULL I: ZAP handler sent bad version number " + msgs.get(1));
            return 156384820;
        }
        if (((Msg)msgs.get(2)).size() != 1 || !this.compare((Msg)msgs.get(2), "1", false)) {
            this.puts("NULL I: ZAP handler sent bad request ID " + msgs.get(2));
            return 156384820;
        }
        if (((Msg)msgs.get(3)).size() != 3) {
            this.puts("NULL I: ZAP handler rejected client authentication " + msgs.get(3));
            return 156384820;
        }
        this.statusCode = new String(((Msg)msgs.get(3)).data(), ZMQ.CHARSET);
        this.setUserId(((Msg)msgs.get(5)).data());
        int rc = this.parseMetadata((Msg)msgs.get(6), 0, true);
        return rc;
    }

    protected final void puts(String msg) {
        System.out.println(this.session + " " + msg);
    }

    protected final void appendData(Msg msg, String data) {
        msg.put((byte)data.length());
        msg.put(data.getBytes(ZMQ.CHARSET));
    }

    public void destroy() {
    }

    public static enum Status {
        HANDSHAKING,
        READY,
        ERROR;

    }
}

